import ast
import pkgutil
from itertools import chain

from pkg_resources import resource_listdir

from . import common
from direct.solo.registered.project import projects


def data(project, config):
    monitoring_service = config.get("monitoring_service")
    sensor = config.get("sensor")
    data_str = "project=\"{}\"," \
               "cluster=\"app_java-jobs\"," \
               "service=\"common-metrics\"," \
               "host=\"CLUSTER\"," \
               "sensor=\"{}\"," \
               "monitoring_service=\"{}\"" \
        .format(project.id, sensor, monitoring_service)
    data_str += common.label_matchers(config)
    return "{" + data_str + "}"


def get_labels(labels_dict):
    conditions = []
    for key in labels_dict:
        conditions.append(
            "get_label(data, \"{}\") == \"{}\"".format(key, labels_dict[key]))
    return " && ".join(conditions)


def lets(labels):
    if labels is None or len(labels) == 0:
        return ""
    lets_arr = []
    for i in range(0, len(labels)):
        lets_arr.append("let label{} = {};".format(i, get_labels(labels[i])))
    return "\n".join(lets_arr)


def ignore_expr(labels):
    if labels is None or len(labels) == 0:
        return "false"
    labels_names = []
    for i in range(0, len(labels)):
        labels_names.append("label" + str(i))
    return " || ".join(labels_names)


def program(project, config):
    ignored_labels = config.get("ignored_labels")
    threshold = config.get("skip_threshold", 0)
    return """
        let data = {0};
        let max_value = max(data);
        {1}

        let ignore = {2};
        alarm_if(max_value > {3} && !ignore);
""".format(
        data(project, config),
        lets(ignored_labels),
        ignore_expr(ignored_labels),
        threshold
    )


def get_alerts_for_project(project, instance):
    export = []
    folder_path = "config/" + instance + "/has_problem/"
    for file in resource_listdir(__package__, folder_path):
        file_path = folder_path + file
        config_str = pkgutil.get_data(__package__, file_path).decode("UTF-8")
        config = ast.literal_eval(config_str)
        assert isinstance(config, dict)
        juggler_description = "Found invalid action in method, please, check alert"
        export += common.alert(project, common.alert_name(file), config, juggler_description, program(project, config))
    return export


alerts_prod = get_alerts_for_project(projects.direct, "production")
alerts_ts = get_alerts_for_project(projects.direct_test, "test")


def get_all_alerts():
    return chain(
        alerts_prod,
        alerts_ts
    )
