from library.python.monitoring.solo.objects.solomon.v2 import MultiAlert, Type, Expression
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects


def pool_alert(sensor, dc):
    id = f"logbroker-production-direct-logshatter2-{sensor}-{dc}"
    urlfmt = "https://solomon.yandex-team.ru/?project=kikimr&cluster=lbk&service=pqtabletAggregatedCounters" + \
                "&l.Account=direct&l.OriginDC={1}&l.sensor={0}&l.ConsumerPath=direct%2Fdirect-logshatter2" + \
                "&l.partition=-&l.user_counters=PersQueue&l.TopicPath={2}&l.host=*&graph=auto"
    url = urlfmt.format(sensor, dc.capitalize(), '{{labels.TopicPath}}'),
    return MultiAlert(
        id=id,
        project_id=projects.direct.id,
        name=id,
        description=f"Алерт {sensor} для direct-logshatter2 consumer для ДЦ {dc}",
        type=Type(
            expression=Expression(
                program="""
                    let points = {{project="kikimr", cluster="lbk", service="pqtabletAggregatedCounters", Account="direct", OriginDC="{1}", sensor="{0}", ConsumerPath="direct/direct-logshatter2", partition="-", user_counters="PersQueue", TopicPath="*", host="*"}};

                    let alarmLag = map(points, line -> last(line) > 3600000);
                    let warnLag = map(points, line -> last(line) > 7200000);

                    let trafficColor = any_of(flatten(alarmLag)) ? "red" : (any_of(flatten(warnLag)) ? "yellow" : "green");
                    alarm_if(any_of(flatten(alarmLag)));
                    warn_if(any_of(flatten(warnLag)));
                    """.format(sensor, dc.capitalize())  # noqa: E501
            )

        ),
        annotations={
            "jugglerHost": "direct.solomon-alert",
            "jugglerService": "direct-logshatter2-{0}-{1}-lag-{2}".format('{{labels.TopicPath}}', sensor, dc),
            "jugglerDescription": "{{#isOk}}нет отставания{{/isOk}}{{^isOk}}высокое отставание топика{{/isOk}}",
            "url": url[0]
        },
        notification_channels={channels.direct_juggler_annotated_full.id},
        window_secs=5 * 60,
        delay_seconds=0,
        group_by_labels={"TopicPath"},
    )


def get_all_alerts():
    sensors = ['ReadTimeLagMs']
    dc = ['man', 'iva', 'vla', 'sas']
    return [pool_alert(s, d) for s in sensors for d in dc]
