from ..common import MdbCluster
from ..common import DbType
from .. import common


class MongoMdbCluster(MdbCluster):
    def __init__(self, cluster_id, name):
        super().__init__(DbType.MONGO, cluster_id, name)


MONGO_CLUSTERS = [
    MongoMdbCluster('aef189d8-93bf-4bca-a416-cf2c09bd9758', 'canvas_mongodb'),
    MongoMdbCluster('mdbupd18rd060lkian1o', 'logshatter_cluster_mdb'),
]


def get_all_alerts():
    alerts = [
        common.create_disk_usage_alert(cluster) for cluster in MONGO_CLUSTERS
    ]
    return common.create_juggler_aggregates(
        DbType.MONGO, MONGO_CLUSTERS, alerts)
