from direct.solo.registered.cluster import mysql

from .common import MdbClusterMysql
from .ptkill import PtKillMysql

MYSQL_CLUSTERS = [
    MdbClusterMysql(cluster_id, name + '-production') for (name, cluster_id) in mysql.production.items()
]


def get_all_alerts():
    alerts = []
    for cluster in MYSQL_CLUSTERS:
        alerts.append(cluster.create_freespace())
        alerts.append(cluster.create_geo_position_master())
        alerts.append(cluster.create_running_threads())
        alerts.append(cluster.create_connecting_threads())
        alerts.append(cluster.create_replication_lag())
        alerts.append(cluster.create_ready_for_operation())
    ptkill = PtKillMysql(MYSQL_CLUSTERS, "production")
    alerts.extend(ptkill.create_juggler_aggregates())
    return alerts
