from juggler_sdk import Check, Child


ENVTYPES = {'production':
               {'cgroup': 'direct_backs',
                'envshort': 'prod'},
            'testing':
               {'cgroup': 'ppcdevs',
                'envshort': 'np'}
            }


class PtKillMysql():
    # список кластаров + окружение к которому их отнести(production/testing)

    def __init__(self, clusters, environ):
        self.clusters = clusters
        self.environ = environ

    def create_child_check_for_cluster(self, host, clusters, environ):
        childs = []
        # service=scripts.ptkill-check.testing.ppc1
        servicefmt = "scripts.ptkill-check.{0}.{1}"
        for cluster in clusters:
            if "ppcdata" not in cluster.get_instance_name():
                continue
            child = Child(
                host=host,
                service=servicefmt.format(
                    environ,
                    cluster.get_instance_shortname()),
                group_type="CGROUP"
            )
            childs.append(child)
        return childs

    def create_juggler_aggregates(self):
        export = []

        meta = ENVTYPES.get(self.environ)
        service_name = "direct-mysql-ptkill-{}".format(self.environ)
        tags_name = [
            'direct-subsystems-health',
            'a_mark_direct.prod_subsystems'] if self.environ == 'production' else [
        ]
        aggregate = Check(
            namespace="direct.{}".format(meta.get('envshort')),
            host="direct.{0}_direct_ptkill_{1}".format(
                meta.get('envshort'), self.environ),
            service=service_name,
            refresh_time=90, ttl=900,
            aggregator="logic_and",
            tags=tags_name,
            children=self.create_child_check_for_cluster(
                meta.get('cgroup'), self.clusters, self.environ)
        )
        export.append(aggregate)
        return export
