from ..common import MdbCluster
from ..common import DbType
from .. import common


class RedisMdbCluster(MdbCluster):
    def __init__(self, cluster_id, name):
        super().__init__(DbType.REDIS, cluster_id, name)


CLUSTERS = [
    RedisMdbCluster('mdboodrr94g6bsv7m22q', 'redis-cache'),
]


def get_all_alerts():
    alerts = [
        common.create_disk_usage_alert(cluster) for cluster in CLUSTERS
    ]
    return common.create_juggler_aggregates(DbType.REDIS, CLUSTERS, alerts)
