from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, Expression
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects

AWACS_TM_ID = 'dtt49untf48po1s3ki1f'
FOLDER_ID = 'fooa07bcrr7souccreru'
URL = "https://yc.yandex-team.ru/folders/{0}/data-transfer/transfer/{1}/view".format(FOLDER_ID, AWACS_TM_ID)


def tm_isactive_alert(tm_id):
    return Alert(
        id="tm-%s-awacs-to-ch-active" % tm_id,
        project_id=projects.direct.id,
        name="tm-%s-awacs-to-ch-active" % tm_id,
        annotations={},
        description="Алерт живости трансфера аваксовых логов из логброкера в кликхаус %s\n URL: %s" % (tm_id, URL) ,
        type=Type(
            expression=Expression(
                program="""
            let runtime_is_stale = tail(series_sum({project="data-transfer",cluster="rtc-prod",service="data-plane",resource_id="%s",group="-", name="runtime.stale"}), 3m);
            let runtime_is_now_stale = max(tail(runtime_is_stale, 2)) == 1;
            let runtime_has_been_stale_half_of_time = avg(runtime_is_stale) > 0.5;
            let dta_01_dataplane_is_alive_alarm = runtime_is_now_stale && runtime_has_been_stale_half_of_time;
            let dta_01_dataplane_is_alive_warn = runtime_is_now_stale;
            let dta_01_dataplane_is_alive_no_data = count(runtime_is_stale) == 0;
            alarm_if(dta_01_dataplane_is_alive_alarm);
            warn_if(dta_01_dataplane_is_alive_warn);
            no_data_if(dta_01_dataplane_is_alive_no_data);
            """ % tm_id
            ),
        ),
        notification_channels={channels.direct_juggler_default.id},
        window_secs=5 * 60,
        delay_seconds=0,
        resolved_empty_policy="RESOLVED_EMPTY_ALARM",
        no_points_policy="NO_POINTS_ALARM"
    )


def tm_iswrite_alert(tm_id):
    return Alert(
        id="tm-%s-awacs-to-ch-write" % tm_id,
        project_id=projects.direct.id,
        name="tm-%s-awacs-to-ch-write" % tm_id,
        annotations={},
        description="""Проверяет, что в таблице в приемнике выполняются какие-либо операции трансфер-менеджером.
                    Загорается CRIT при неработающем ТМ
                    URL: %s""" % URL,
        type=Type(
            expression=Expression(
                program="""
                let sinker_table_rows = series_max(
                {project="data-transfer",cluster="rtc-prod",service="data-plane",resource_id="%s",group="-", runtime="*",table="awacs_l7_logs_lr", shard="-|*",name="sinker.table.rows.total"});
                let sinker_table_rows_dt = derivative(sinker_table_rows);
                alarm_if(max(sinker_table_rows_dt) <= 0);
                warn_if(max(tail(sinker_table_rows_dt, 1m)) == 0);
                alarm_if(count(sinker_table_rows_dt) == 0);
            """ % tm_id
            )

        ),
        notification_channels={channels.direct_juggler_default.id},
        window_secs=5 * 60,
        delay_seconds=15,
        resolved_empty_policy="RESOLVED_EMPTY_NO_DATA",
    )


def get_all_alerts():
    alerts = [tm_isactive_alert(AWACS_TM_ID), tm_iswrite_alert(AWACS_TM_ID)]
    return alerts
