from juggler_sdk import Check, Child

memcached_ppc_check = Check(
    namespace="direct.prod",
    host='direct.infra.memcached',
    service='memcached-ppc',
    refresh_time=90, ttl=900,
    aggregator="logic_and",
    description="Memcached aliveness",
    children=[Child(
        host='direct_ng_backs',
        service='memcached-ppc',
        group_type="CGROUP"
    )]
)


def get_alerts():
    return [
        memcached_ppc_check,
    ]
