from juggler_sdk import Check, Child
from direct.solo.registered.external_services.zookeeper import KazooClientDirectPpcback
import json


def get_juggler_alerts():
    checks = []
    zk = KazooClientDirectPpcback()
    zk.start()
    alldb_data, _ = zk.get('/direct/alldb-config.json')
    alldb_settings = json.loads(alldb_data)
    head_juggler_service = "mysql-binlog-age"
    instances = alldb_settings.get("instances", "")
    aggr_childs = []
    juggler_namespace = "direct.prod"
    for instance in instances:
        original_instance_name=instance
        if not instance.count("ppcdict") and not instance.count("ppcdata"):
            continue
        if instance.count("ppcdata"):
            instance = instance.replace("data", "")
        juggler_service = "{0}-{1}".format(head_juggler_service, instance)
        juggler_host = "direct.prod_monitoring"
        checks.append(Check(
            namespace=juggler_namespace,
            host=juggler_host,
            service=juggler_service,
            aggregator="logic_and",
            refresh_time=90, ttl=900,
            tags=['mysql.' + original_instance_name],
            children=[Child(
                host='direct_backs',
                service=juggler_service + "-production",
                group_type='CGROUP')],
        ))
        aggr_childs.append(Child(
            host=juggler_host,
            group_type='HOST',
            service=juggler_service))
    checks.append(Check(
        namespace=juggler_namespace,
        host=juggler_host,
        service=head_juggler_service,
        refresh_time=90, ttl=900,
        aggregator="logic_or",
        tags=['direct-subsystems-health', 'a_mark_direct.prod_subsystems'],
        children=aggr_childs
    ))
    return checks


def get_all_alerts():
    return get_juggler_alerts()
