from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, Expression
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects

WARN_LIMIT = 80
CRIT_LIMIT = 90
CPU_DOC_LINK = 'https://ydb.yandex-team.ru/docs/troubleshooting/diag_dashboard#cpu-shortage'
MEM_DOC_LINK = 'https://ydb.yandex-team.ru/docs/troubleshooting/diag_dashboard#memory-shortage'


def get_cpu_alter(ydb_database):
    return Alert(
        id="ydb-cpu-usage-{0}-{1}".format(ydb_database.cluster, ydb_database.db_name.replace("/", "-")),
        project_id=projects.direct.id,
        name="ydb-cpu-usage {0}:{1}".format(ydb_database.cluster, ydb_database.db_name),
        annotations={
            "host": "direct-ydb",
            "service": "ydb-cpu-usage-{0}-{1}".format(ydb_database.cluster, ydb_database.db_name),
            "description": "Cpu usage for database-{0}:{1}".format(ydb_database.cluster, ydb_database.db_name) +
                           " is {{expression.agv_utilization_by_hosts}}" +
                           "warn limit={0}, crit limit={1}".format(WARN_LIMIT, CRIT_LIMIT) +
                           "Doc: {0}".format(CPU_DOC_LINK)

        },
        description="Потребление cpu базой {0}:{1}, "
                    "документация {2}".format(ydb_database.cluster, ydb_database.db_name, CPU_DOC_LINK),
        type=Type(
            expression=Expression(
                program="""
                let el= {0};
                let total = {1} + el;

                let utilization = el/total * 100;
                let agv_utilization_by_hosts = avg(series_max(utilization));
                warn_if(agv_utilization_by_hosts > {2});
                alarm_if(agv_utilization_by_hosts > {3});
            """.format(
                    Sensor(
                        project="kikimr", cluster=ydb_database.cluster, service="utils", execpool="User",
                        host="*", sensor="ElapsedMicrosec", database=ydb_database.db_name, slot="cluster"
                    ),
                    Sensor(
                        project="kikimr", cluster=ydb_database.cluster, service="utils", execpool="User",
                        host="*", sensor="ParkedMicrosec", database=ydb_database.db_name, slot="cluster"
                    ),
                    WARN_LIMIT, CRIT_LIMIT
                )
            )

        ),
        notification_channels={channels.direct_juggler.id},
        window_secs=10 * 60,
        delay_seconds=0,
    )


def get_mem_alter(ydb_database):
    return Alert(
        id="ydb-mem-usage-{0}-{1}".format(ydb_database.cluster, ydb_database.db_name.replace("/", "-")),
        project_id=projects.direct.id,
        name="ydb-mem-usage {0}:{1}".format(ydb_database.cluster, ydb_database.db_name),
        annotations={
            "host": "direct-ydb",
            "service": "ydb-mem-usage-{0}-{1}".format(ydb_database.cluster, ydb_database.db_name),
            "description": "Memory usage for database-{0}:{1}".format(ydb_database.cluster, ydb_database.db_name) +
                           " is {{expression.agv_utilization_by_hosts}}" +
                           "warn limit={0}, crit limit={1}".format(WARN_LIMIT, CRIT_LIMIT) +
                           "Doc: {0}".format(MEM_DOC_LINK)

        },
        description="Потребление mem базой {0}:{1}, "
                    "документация {2}".format(ydb_database.cluster, ydb_database.db_name, MEM_DOC_LINK),
        type=Type(
            expression=Expression(
                program="""
                let used = {0};
                let total = {1};

                let utilization = used/total * 100;
                let agv_utilization_by_hosts = avg(series_max(utilization));
                warn_if(agv_utilization_by_hosts > {2});
                alarm_if(agv_utilization_by_hosts > {3});
            """.format(
                    Sensor(
                        project="kikimr", cluster=ydb_database.cluster, service="utils",
                        host="*", sensor="Process/AnonRssSize", database=ydb_database.db_name, slot="cluster"
                    ),
                    Sensor(
                        project="kikimr", cluster=ydb_database.cluster, service="utils",
                        host="*", sensor="Process/CGroupMemLimit", database=ydb_database.db_name, slot="cluster"
                    ),
                    WARN_LIMIT, CRIT_LIMIT
                )
            )

        ),
        notification_channels={channels.direct_juggler.id},
        window_secs=10 * 60,
        delay_seconds=0,
    )
