from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, Expression
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects

WINDOW_MINUTES = 60  # Длительность измерения в минутах
MAX_LAG_MINUTES = 5  # Допустимое отставание обработки от действия
CRIT_ERROR_MIN = 10  # Минимальное количество необработанных действия для крита


clicks_loss = Alert(
    id="communication_platform_clicks_loss",
    project_id=projects.direct.id,
    name="Необработанные изменения событий в коммуникационной платформе",
    description="Проверяет наличие необработанных изменений событий.",
    window_secs=WINDOW_MINUTES * 60,
    delay_seconds=0,
    notification_channels={channels.direct_juggler_annotated.id},
    annotations={
        "logbroker_count": "{{expression.logbroker_count}}",
        "caesar_count": "{{expression.caesar_count}}",
        "count_diff": "{{expression.count_diff}}",
        "time_diff": "{{expression.time_diff}}",
        "jugglerHostSuffix": "java-web",
        "jugglerService": "communication-platform",
        "url": "https://solomon.yandex-team.ru/admin/projects/direct/alerts/{{alert.id}}",
        "jugglerDescription": "{{#isOk}}OK{{/isOk}}" +
                              "{{#isAlarm}}{{expression.count_diff}} (>{{expression.count_diff_limit}}) отправленных событий не обработано. {{/isAlarm}}" +
                              "{{^isOk}}Последнее отправленное на {{expression.time_diff}} секунд позже последней обработки события.{{/isOk}}",
    },
    type=Type(
        expression=Expression(
            program="""
                let logbroker = {logbroker};
                let caesar = {caesar};

                let caesar_period_seconds = 60 * round((max((get_timestamps(caesar))) - min((get_timestamps(caesar))))/60);
                let logbroker_period_seconds = 60 * round((max((get_timestamps(drop_tail(logbroker, {max_lag}m)))) - min((get_timestamps(drop_tail(logbroker, {max_lag}m)))))/60);

                let logbroker_rps= avg(drop_tail(logbroker, {max_lag}m));
                let caesar_rps = avg(caesar);

                let logbroker_count = round(logbroker_rps * logbroker_period_seconds);
                let caesar_count = round(caesar_rps * caesar_period_seconds);
                let count_diff = logbroker_count - caesar_count;

                let last_logbroker = max(get_timestamps(tail(drop_below(drop_tail(logbroker, {max_lag}m), 0.0001),1)));
                let last_caesar = max(get_timestamps(tail(drop_below(caesar, 0.0001),1)));
                let time_diff = last_logbroker - last_caesar;

                let count_diff_limit = {crit_error_min};

                alarm_if((last_logbroker>last_caesar) && (count_diff > count_diff_limit));
                warn_if(last_logbroker>last_caesar);
                """.format(
                logbroker=Sensor(
                    project="kikimr", cluster="lbkx", service="pqproxy_writeSession",
                    host="cluster", Account="direct", OriginDC="cluster",
                    TopicPath="direct/communication-events", Topic=("!=", "total"), Producer=("!=", "total"),
                    sensor="MessagesWrittenOriginal"
                ),
                caesar=Sensor(
                    project="caesar", cluster="caesar_1", service="caesar_1",
                    host="cluster", graph="communications_graph",
                    sensor="communications.channel.write"
                ),
                max_lag=MAX_LAG_MINUTES,
                crit_error_min=CRIT_ERROR_MIN,
            )
        )
    ),
)

exports=[clicks_loss]
