from library.python.monitoring.solo.objects.solomon.v2 import MultiAlert, Type, Expression
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects


def pool_alert(app):
    id = f"app-dbpool-{app}"
    return MultiAlert(
        id=id,
        project_id=projects.direct.id,
        name=id,
        annotations={
            "host": "direct-l7",
            "service": id,
            "description": f"Utilization of mysql connection pools for app {app}"
        },
        description=f"Utilization of mysql connection pools for app {app}",
        type=Type(
            expression=Expression(
                program="""
                    let total = group_lines('max', {{project="direct", cluster="app_{0}", service="java-monitoring", pool_name="*", type="pool", env="production", sensor="max_conns", host!=="CLUSTER"}});
                    let used = group_lines('max', {{project="direct", cluster="app_{0}", service="java-monitoring", pool_name="*", type="pool", env="production", sensor="db_active_conns", host!=="CLUSTER"}});
                    let used_perc = avg(100.0 * used / total);
                    alarm_if(used_perc > 70);
                    warn_if(used_perc > 50);
                    """.format(app)  # noqa: E501
            )

        ),
        notification_channels={channels.direct_juggler.id},
        window_secs=5 * 60,
        delay_seconds=0,
        group_by_labels={"pool_name"},
    )


def get_all_alerts():
    apps = ['java-api5', 'java-intapi', 'java-jobs', 'java-web']
    return [pool_alert(app) for app in apps]
