from juggler_sdk import Check, Child

from direct.solo.registered.juggler import reference
from direct.solo.registered.juggler.reference import CALLING_CHECKS_CHAT
from direct.solo.registered.juggler.reference import DUTY_ESCALATION

active_orders_call_check = Check(
    namespace=reference.NAMESPACE_PROD,
    host='direct.prod',
    service="active_orders_call",
    aggregator="logic_or",
    ttl=900,
    refresh_time=90,
    children=[
        Child(host="checks_auto.direct.yandex.ru", service="jobs.ActiveOrdersImportJob.working.production"),
    ],
    tags=[
        'directadmin_TV',
        'direct_group_sre',
        'a_mark_direct.prod_javaperl',
    ],
    meta={
        "urls": [
            {
                "type": "wiki",
                "title": "Документация",
                "url": "https://docs.yandex-team.ru/direct-dev/reference/jobs/list/ActiveOrdersImportJob?searchQuery=ActiveOrdersIm#activeordersimportjob"
            },
        ]
    },
    notifications=[
        DUTY_ESCALATION,
        CALLING_CHECKS_CHAT,
    ],
)

exports = [
    active_orders_call_check,
]
