from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, PredicateRule, Threshold

from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects
from direct.solo.registered.sensors.ess import common_ess_topics_read_lag_ms

CRIT_DELAY_SEC = 10 * 60

HOST_SUFFIX = "direct-jobs"
SERVICE_ESS_READ_LAG = "ess-consumer-read-lag"

processors_delay_alert = Alert(
    id="ess-consumer-lb-read-lag",
    project_id=projects.direct.id,
    name="ess-consumer-lb-read-lag # solo",
    description="Отставание вычитывания данных у ess-consumer",
    annotations={
        "jugglerHostSuffix": HOST_SUFFIX,
        "jugglerService": SERVICE_ESS_READ_LAG,
        "jugglerDescription": "{{#isAlarm}}ESS-consumer read lag is greater than " +
                              str(CRIT_DELAY_SEC) + " sec{{/isAlarm}}",
        "url": "https://solomon.yandex-team.ru/admin/projects/direct/alerts/{{alert.id}}",
    },
    type=Type(
        threshold=Threshold(
            selectors=common_ess_topics_read_lag_ms.selectors,
            time_aggregation="LAST_NON_NAN",
            predicate="GT",
            threshold=CRIT_DELAY_SEC * 1000,  # to millis
            predicate_rules=[
                PredicateRule(
                    threshold_type="LAST_NON_NAN",
                    comparison="GT",
                    threshold=CRIT_DELAY_SEC * 1000,  # to millis
                    target_status="ALARM"
                ),
            ],
        ),
    ),
    notification_channels={
        channels.direct_juggler_annotated.id
    },
    window_secs=5 * 60,
    delay_seconds=0,
)

exports = [
    processors_delay_alert,
]
