from juggler_sdk import Check, Child

from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, Expression
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects

successes_alert = Alert(
    id="direct-jobs-successes-2",
    project_id=projects.direct.id,
    name="direct-jobs-successes",
    annotations={
        "host": "direct-jobs",
        "service": "jobs-successes",
        "description": "{{#isAlarm}}direct-jobs has less than 50 jobs successes per second{{/isAlarm}}"
    },
    description="(создан из solo, не для direct-sre) Количество успешно отработавших задач - не меньше 50 в секунду (с учётом демонов)",
    type=Type(
        expression=Expression(
            program="""
                let successes = non_negative_derivative({0});
                alarm_if(avg(successes) < 50);
            """.format(Sensor(
                project="direct", cluster="app_java-jobs", service="java-monitoring",
                host="CLUSTER", sensor="hourglass_successes", env="production"
            ))
        )

    ),
    notification_channels={channels.direct_juggler.id},
    window_secs=10 * 60,
    delay_seconds=0,
)

successes_check = Check(
    namespace="direct.prod",
    host=successes_alert.annotations["host"],
    service=successes_alert.annotations["service"],
    refresh_time=90, ttl=900,
    aggregator="logic_or",
    # tags=["is_disaster", "marty", "warden_alert_create_spi", "call_needed", "disaster_alert", "yabs_partner"],
    children=[Child(
        host=successes_alert.annotations["host"],
        service=successes_alert.annotations["service"],
        group_type="HOST"
    )]
)

exports = [
    successes_alert, successes_check
]
