from juggler_sdk import Check, Child
from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, PredicateRule, Threshold

from direct.solo.registered.channel import channels
from direct.solo.registered.juggler import reference
from direct.solo.registered.project import projects
from direct.solo.registered.sensors.ess import moderation_export_read_lag_ms
from direct.solo.registered.juggler.reference import CALLING_CHECKS_CHAT
from direct.solo.registered.juggler.reference import DUTY_ESCALATION

# Порог берем меньше, чем sla на модерацию сайтлинков и текстовых баннеров (direct:$impact_clients_3_high):
# https://docs.yandex-team.ru/direct-dev/incidents/spi-ticket#impact-clients
CRIT_DELAY = 40 * 60

HOST_SUFFIX = "moderation_export"
SERVICE_TOPIC_READ_DELAY = "topic_read_delay"

moderation_export_read_topic_delay_alert = Alert(
    id="moderation_export_read_topic_delay_ms",
    project_id=projects.direct.id,
    name="moderation_export_read_topic_delay_ms # solo",
    annotations={
        "jugglerHostSuffix": HOST_SUFFIX,
        "jugglerService": SERVICE_TOPIC_READ_DELAY,
        "jugglerDescription": "Отставание вычитки событий модерации из logbroker {{#isOk}}в норме{{/isOk}}" +
                              "{{^isOk}}превышает {{#isAlarm}}" + str(CRIT_DELAY) + "{{/isAlarm}}{{/isOk}}",
        "url": "https://solomon.yandex-team.ru/admin/projects/direct/alerts/{{alert.id}}",
        "trafficLight": "{{expression.trafficColor}}",
    },
    type=Type(
        threshold=Threshold(
            selectors=moderation_export_read_lag_ms.selectors,
            time_aggregation="LAST_NON_NAN",
            predicate="GT",
            threshold=CRIT_DELAY * 1000,  # to millis
            predicate_rules=[
                PredicateRule(
                    threshold_type="LAST_NON_NAN",
                    comparison="GT",
                    threshold=CRIT_DELAY * 1000,  # to millis
                    target_status="ALARM"
                ),
            ],
        ),
    ),
    notification_channels={
        channels.direct_juggler_annotated.id
    },
    window_secs=10 * 60,
    delay_seconds=0,
)

moderation_export_read_topic_delay_check = Check(
    namespace=reference.NAMESPACE_PROD,
    host='direct.prod',
    service="moderation_export_delay",
    aggregator="logic_or",
    ttl=600,
    refresh_time=60,
    children=[
        Child(host=channels.get_solomon_host(HOST_SUFFIX), service=SERVICE_TOPIC_READ_DELAY),
    ],
    tags=[
        'directadmin.calls',
        'direct_group_sre',
    ],
    meta={
        "urls": [
            {
                "type": "wiki",
                "title": "документация",
                "url": "https://docs.yandex-team.ru/direct-dev/reference/alerts/ess-moderation-export-lag"
            },
        ]
    },
    notifications=[
        CALLING_CHECKS_CHAT,
        DUTY_ESCALATION,
    ],
)

exports = [
    moderation_export_read_topic_delay_alert,
    moderation_export_read_topic_delay_check,
]
