from library.python.monitoring.solo.objects.solomon.v2 import Channel, Method, Juggler, Telegram
from direct.solo.registered.project import projects

DIRECT_GROUP_INTERNAL_SYSTEMS_CHAT_ID = 'DISMonitoring'
DIRECT_APP_DUTY_MONITORING_CHAT_ID = 'direct-app-duty-monitoring'
DIRECT_TEST_COORDINATION_CHAT_ID = 'test_coordination_chat'


def get_solomon_host(hostSuffix=None, production=True):
    host = "direct.solomon-alert" if production else "direct-test.solomon-alert"
    if hostSuffix is not None:
        return host + "." + hostSuffix
    else:
        return host


direct_juggler = Channel(
    id='juggler',
    project_id=projects.direct.id,
    name='juggler #solo',
    notify_about_statuses={"NO_DATA",
                           "OK",
                           "ERROR",
                           "ALARM",
                           "WARN"},
    method=Method(
        juggler=Juggler(
            host="{{{annotations.host}}}",
            service='{{{annotations.service}}}',
            tags=["{{{annotations.tags}}}"],
            description=''
        ))
)

direct_juggler_default = Channel(
    id='juggler-default',
    project_id=projects.direct.id,
    name='juggler-default #solo',
    notify_about_statuses={"NO_DATA",
                           "OK",
                           "ERROR",
                           "ALARM",
                           "WARN"},
    method=Method(
        juggler=Juggler(
            host=get_solomon_host(),
            service='{{alert.id}}',
            tags=["{{annotations.jugglerTags}}"],
            description=''
        ))
)

BASE_JUGGLER_PARAMS = dict(
    service="{{annotations.jugglerService}}",
    tags=["{{annotations.jugglerTags}}"],
    description='{{annotations.jugglerDescription}}\n{{{annotations.url}}}\n{{status.description}}'
)


def create_juggler_annotated(production):
    return Channel(
        id='juggler-annotated',
        project_id=projects.direct.id if production else projects.direct_test.id,
        name='juggler-annotated #solo',
        notify_about_statuses={"NO_DATA",
                               "OK",
                               "ERROR",
                               "ALARM",
                               "WARN"},
        method=Method(
            juggler=Juggler(
                host=get_solomon_host(hostSuffix="{{annotations.jugglerHostSuffix}}", production=production),
                **BASE_JUGGLER_PARAMS
            ))
    )

# одинаковый id, поэтому можно использовать любой
direct_juggler_annotated = create_juggler_annotated(production=True)
direct_test_juggler_annotated = create_juggler_annotated(production=False)

direct_juggler_annotated_full = Channel(
    id='juggler-annotated-full',
    project_id=projects.direct.id,
    name='полностью конфигуририруемый juggler #solo',
    notify_about_statuses={"NO_DATA",
                           "OK",
                           "ERROR",
                           "ALARM",
                           "WARN"},
    method=Method(
        juggler=Juggler(
            host="{{annotations.jugglerHost}}",
            **BASE_JUGGLER_PARAMS
        ))
)


direct_test_juggler = Channel(
    id='juggler',
    project_id=projects.direct_test.id,
    name='juggler #solo',
    notify_about_statuses={"NO_DATA",
                           "OK",
                           "ERROR",
                           "ALARM",
                           "WARN"},
    method=Method(
        juggler=Juggler(
            host="{{{annotations.host}}}",
            service='{{{annotations.service}}}',
            tags=["{{{annotations.tags}}}"],
            description=''
        ))
)

direct_group_internal_systems_chat = Channel(
    id='DISMonitoring',
    project_id=projects.direct.id,
    name='Мониторинг группы разработки внутренних систем Директа',
    method=Method(
        telegram=Telegram(
            group_title="Мониторинг группы разработки внутренних систем Директа",
            text_template='{{alert.name}} is {{status.code}}.'
                + '\n{{annotations.jugglerDescription}}'
                + '\n\nhttps://solomon.yandex-team.ru/admin/projects/direct/alerts/{{alert.id}}'
            ,
        ),
    ),
    notify_about_statuses={
        'NO_DATA',
        'OK',
        'ALARM',
        'WARN',
        'ERROR',
    },
)

direct_duty_chat = Channel(
    id='direct-prod-problems',  # Дежурство в Директе
    project_id=projects.direct.id,
    name='Тревожный чат',
    method=Method(
        telegram=Telegram(
            group_title="Дежурство в Директе",
            text_template='{{#isAlarm}}{{annotations.alarmMessage}}{{/isAlarm}}'
                + '{{#isOk}}{{annotations.okMessage}}{{/isOk}}'
                + '\n\nАлерт: https://solomon.yandex-team.ru/admin/projects/direct/alerts/{{alert.id}}'
        ),
    ),
    notify_about_statuses={
        'OK',
        'ALARM',
    },
)

exports = [
    direct_juggler,
    direct_juggler_default,
    direct_juggler_annotated,
    direct_juggler_annotated_full,
    direct_test_juggler,
    direct_test_juggler_annotated,
    direct_group_internal_systems_chat,
    direct_duty_chat,
]
