from itertools import chain

from direct.solo.registered.cluster.balancer import exports as balancer_exports
from direct.solo.registered.cluster.app_java_api5 import exports as api5_exports
from direct.solo.registered.cluster.app_java_jobs import exports as jobs_exports
from direct.solo.registered.cluster.app_java_intapi import exports as intapi_exports
from direct.solo.registered.cluster.app_java_web import exports as web_exports
from direct.solo.registered.cluster.deploy_java_apps import export_java_app_in_deploy_clusters as deploy_java_apps_exports
from direct.solo.registered.cluster.nginx_access import exports as nginx_access_exports
from direct.solo.registered.cluster.wordstat import exports as wordstat_exports


def get_all_clusters():
    return list(chain(
        balancer_exports,
        api5_exports,
        intapi_exports,
        jobs_exports,
        web_exports,
        deploy_java_apps_exports,
        nginx_access_exports,
        wordstat_exports,
    ))


def get_java_clusters():
    return list(chain(
        api5_exports,
        intapi_exports,
        jobs_exports,
        web_exports,
        deploy_java_apps_exports,
    ))
