from library.python.monitoring.solo.objects.solomon.v2 import Cluster, ConductorGroup
from direct.solo.registered.project import projects
from direct.solo.registered.external_services.apps_conf import get_apps_deploy_places, build_yp_cluster


def build_cluster(project_id, **kwargs):
    name = "app_java-jobs"
    return Cluster(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=10186,
        use_fqdn=True,
        **kwargs
    )

app_deploy_places = get_apps_deploy_places().get('java-jobs')

jobs_prod = build_cluster(
    projects.direct.id,
    conductor_groups={
        ConductorGroup(group="direct_java_jobs_rtc", labels=set()),
    },
    yp_clusters=build_yp_cluster(**(app_deploy_places['production'])),
)

jobs_test = build_cluster(
    projects.direct_test.id,
    conductor_groups={
        ConductorGroup(group="direct_testnets_jobs_ts", labels=set()),
        ConductorGroup(group="direct_testnets_jobs_dev7", labels=set()),
        ConductorGroup(group="direct_testnets_jobs_devtest", labels=set()),
    })

exports = [
    jobs_prod,
    jobs_test,
]
