from library.python.monitoring.solo.objects.solomon.v2 import Cluster, YpCluster
from direct.solo.registered.project import projects


def build_cluster(name, id_template="%s_awacs_%s", **kwargs):
    project_id = projects.direct.id
    return Cluster(
        id=id_template % (project_id, name),
        name=name,
        project_id=project_id,
        **kwargs
    )


direct_api_balancer = build_cluster(
    name="api.direct.yandex.ru",
    yp_clusters={
        YpCluster(pod_set_id='rtc-balancer-api-direct-yandex-ru-%s' % dc, cluster=dc) for dc in ('sas', 'vla', 'iva')
    },
)
direct_canvas_balancer = build_cluster(
    name="canvas-back.direct.yandex.net",
    yp_clusters={
        YpCluster(pod_set_id='rtc-balancer-canvas-back-direct-yandex-net-%s' % dc, cluster=dc) for dc in ('myt', 'sas', 'vla')
    },
)
direct_balancer = build_cluster(
    name="direct.yandex.ru",
    yp_clusters={
        YpCluster(pod_set_id='rtc-balancer-direct-yandex-ru-%s' % dc, cluster=dc) for dc in ('myt', 'sas', 'vla')
    },
)
direct_intapi_balancer = build_cluster(
    name="intapi.direct.yandex.ru",
    yp_clusters={
        YpCluster(pod_set_id='rtc-balancer-intapi-direct-yandex-ru-%s' % dc, cluster=dc) for dc in ('iva', 'sas', 'vla')
    },
)
direct_pages_balancer = build_cluster(
    name="direct-pages-internal.yandex.net",
    yp_clusters={
        YpCluster(pod_set_id='rtc-balancer-direct-pages-internal-yandex-net-%s' % dc, cluster=dc) for dc in ('man', 'sas', 'vla')
    },
)
uac_balancer = build_cluster(
    name="uac.yandex.ru",
    id_template="%s_%s",
    yp_clusters={
        YpCluster(pod_set_id='rtc-balancer-uac-yandex-ru-%s' % dc, cluster=dc) for dc in ('man', 'sas', 'vla')
    },
)


exports = [
    direct_api_balancer,
    direct_canvas_balancer,
    direct_balancer,
    direct_intapi_balancer,
    direct_pages_balancer,
    uac_balancer,
]
