from library.python.monitoring.solo.objects.solomon.v2 import Cluster
from direct.solo.registered.external_services.apps_conf import ENV_NAMES_BY_PROJECT_ID, get_apps_deploy_places, build_yp_cluster


def build_cluster(name, prj_id, **kwargs):
    return Cluster(
        id="%s_%s" % (prj_id, name),
        name=name,
        project_id=prj_id,
        **kwargs
    )


export_java_app_in_deploy_clusters = []


for app, envs in get_apps_deploy_places().items():
    for project_id, project_envs in ENV_NAMES_BY_PROJECT_ID.items():
        yp_clusters = {
            yp_cluster
            for env_name, env in envs.items()
            if env_name in project_envs
            for yp_cluster in build_yp_cluster(**env)
        }

        if not yp_clusters:
            continue

        app_cluster = build_cluster(
            name=f'{app}_deploy',
            prj_id=project_id,
            yp_clusters=yp_clusters,
        )

        export_java_app_in_deploy_clusters += [app_cluster]
