from library.python.monitoring.solo.objects.solomon.v2 import Cluster, ConductorGroup
from direct.solo.registered.project import projects
from direct.solo.registered.external_services.apps_conf import get_apps_deploy_places, build_yp_cluster


def build_cluster(project_id, **kwargs):
    name = "nginx-access"
    return Cluster(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=10931,
        use_fqdn=True,
        **kwargs
    )


app_deploy_places = get_apps_deploy_places()

nginx_access_prod = build_cluster(
    projects.direct.id,
    conductor_groups={
        ConductorGroup(group="direct_frontends", labels=set()),
        ConductorGroup(group="direct_soap", labels=set()),
        ConductorGroup(group="direct_intapi_rtc", labels=set()),
        ConductorGroup(group="direct_java_intapi_rtc", labels=set()),
        ConductorGroup(group="direct_java_logviewer_rtc", labels=set()),
        ConductorGroup(group="direct_web_api_rtc", labels=set()),
        ConductorGroup(group="direct_canvas_rtc", labels=set()),
        ConductorGroup(group="direct_api5_rtc", labels=set()),
    },
    yp_clusters=build_yp_cluster(**(app_deploy_places['canvas']['production'])),
)

nginx_access_test = build_cluster(
    projects.direct_test.id,
    conductor_groups={
        ConductorGroup(group="direct_java_test_java_web_rtc", labels=set()),
        ConductorGroup(group="direct_java_test_java_intapi_rtc", labels=set()),
        ConductorGroup(group="direct_java_test_java_api5_rtc", labels=set()),
        ConductorGroup(group="direct_java_test_canvas_rtc", labels=set()),
    },
)

exports = [
    nginx_access_prod,
    nginx_access_test,
]
