from library.python.monitoring.solo.objects.solomon.v2 import Cluster, YpCluster
from direct.solo.registered.project import projects


def build_cluster(project_id, name, **kwargs):
    return Cluster(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        use_fqdn=True,
        **kwargs
    )


wordstat_app = build_cluster(
    project_id=projects.direct.id,
    name='wordstat',
    yp_clusters={
        YpCluster(pod_set_id='advq-wordstat-production.wordstat', cluster=dc, labels=set(['dc=%s' % dc])) for dc in ('man', 'sas', 'vla')
        },
        port=10999,
    )

wordstat_slb = build_cluster(
    project_id=projects.direct.id,
    name='awacs_wordstat.yandex.ru',
    yp_clusters={
        YpCluster(pod_set_id='rtc-balancer-wordstat-yandex-ru-%s' % dc, cluster=dc) for dc in ('myt', 'sas', 'vla')
        },
    )

exports = [
    wordstat_app,
    wordstat_slb
]
