# -*- coding: utf-8 -*-
from direct.solo.registered.graph.direct_balancer import http, connections, backends, general, ssl, system
from direct.solo.registered.sensors.balancer import outgoing_2xx

from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel, Parameter
from direct.solo.registered.cluster import clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service import services


def build_sensor_link(sensor):
    params = dict(cs="default", interpolate="linear")
    return sensor.build_sensor_link(parameters=params, full_link=False)


PARAMETRISE = {
    'host': '{{host}}',
    'cluster': '{{cluster}}',
    'service': '{{service}}',
}


def generate_row(graphs):
    parametrize = PARAMETRISE
    return Row(
        panels=[
            Panel(
                url=graph.get_dashboard_link(parametrise=parametrize),
                title=graph.name
            ) for graph in graphs
        ]
    )


l7_total_dashboard = Dashboard(
    id='l7_total_dashboard',
    project_id=projects.direct.id,
    name='L7 Total Dashboard (Solo)',
    parameters={Parameter(name='cluster', value=clusters.direct_api_balancer.name),
                Parameter(name='service', value=services.direct_awacs.name),
                Parameter(name='host', value='*')},
    rows=[
        Row(
            panels=[
                Panel(
                    title="2xx",
                    url=build_sensor_link(
                        outgoing_2xx.mutate(cluster="{{cluster}}", host="{{host}}", service="{{service}}")),
                )
            ]
        ),
        generate_row([http.outgoing_3xx, http.outgoing_4xx, http.outgoing_5xx]),
        generate_row([connections.stats, connections.errors]),
        generate_row([backends.stats, backends.errors,
                      backends.processing_time_percentiles, backends.limited_attempts]),
        generate_row([general.stats, general.connections]),
        generate_row([ssl.stats, ssl.tls, ssl.errors]),
        generate_row([system.worker_cpu_usage, connections.http2_stats])],
    height_multiplier=2.0
)

exports = [l7_total_dashboard]
