from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel, Parameter

from direct.solo.registered.graph.bs_export import logbroker_requests_graph, logbroker_sent_objects
from direct.solo.registered.graph.bs_export import std_graph, heavy_graph, buggy_graph, other_camps_graph, all_queue_delayed_clients_percent
from direct.solo.registered.project import projects
from direct.solo.registered.cluster.app_java_jobs import jobs_prod
from direct.solo.registered.service.bs_export_queue import direct_bs_export_queue as queue_service
from direct.solo.registered.sensors.transport_queues import bs_export_campaigns_count, bs_export_clients_count, bs_export_max_queue_age


bsexport_queue_templated=Dashboard(
    id='bs-export-queue-templated',
    project_id=projects.direct.id,
    name='perl экспорт в БК (очередь {{queue}})',
    parameters={
        Parameter(name='cluster', value=jobs_prod.name),
        Parameter(name='service', value=queue_service.name),
        Parameter(name='queue', value='*|-'),
    },
    rows=[
        Row(panels=[
            Panel(
                title="Кампаний в очереди",
                url=bs_export_campaigns_count.mutate(queue="{{queue}}").build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
            ),
            Panel(
                title="Возраст очереди по шардам",
                subtitle="в минутах",
                url=bs_export_max_queue_age.mutate(queue="{{queue}}", shard="*").build_sensor_link(
                    parameters={
                        'stack': 'false',
                        'cs': 'default',
                        'min': '0',
                    },
                    full_link=False
                ),
            ),
        ]),
        Row(panels=[
            Panel(
                title="Распределение кампаний по времени в очереди",
                subtitle="в минутах",
                url=bs_export_campaigns_count.mutate(queue="{{queue}}").build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'norm': 'true',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
            ),
            Panel(
                title="Перцентили возраста очереди",
                subtitle="в минутах",
                url=bs_export_campaigns_count.mutate(queue="{{queue}}").build_sensor_link(
                    parameters={
                        'overLinesTransform': 'WEIGHTED_PERCENTILE',
                        'percentiles': '80,95,99',
                    },
                    full_link=False
                ),
            ),
        ]),
        Row(panels=[
            Panel(
                title="Клиентов в очереди",
                url=bs_export_clients_count.mutate(queue="{{queue}}").build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
            ),
            Panel(
                title="Клиентов с отставанием более 90 минут",
                url=all_queue_delayed_clients_percent.get_dashboard_link(use_legend=False, parametrise={'queue': '{{queue}}'}),
            ),
        ]),
        Row(panels=[
            Panel(
                title="Распределение клиентов по времени в очереди",
                subtitle="в минутах",
                url=bs_export_clients_count.mutate(queue="{{queue}}").build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'norm': 'true',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
            ),
        ]),
    ],
    height_multiplier=1.0,
)

bsexport_common = Dashboard(
    id='bs-export-perl',
    project_id=projects.direct.id,
    name='perl экспорт в БК (общая картина)',
    parameters=set(),
    rows=[
        Row(panels=[
            Panel(
                title="Распределение кампаний по времени в очереди",
                url=bs_export_campaigns_count.build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'norm': 'true',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
                rowspan=2,
            ),
            Panel(
                title="Очередь STD",
                subtitle="число кампаний и перцентили возраста",
                url=std_graph.get_dashboard_link(use_legend=False),
            ),
            Panel(
                title="Запись в logbroker",
                subtitle='(direct-banners-log)',
                url=logbroker_requests_graph.get_dashboard_link(),
            ),
        ]),
        Row(panels=[
            Panel(
                title="Очередь HEAVY",
                subtitle="число кампаний и перцентили возраста",
                url=heavy_graph.get_dashboard_link(use_legend=False),
            ),
            Panel(
                title="Ссылки",
                type="MARKDOWN",
                url="",
                markdown="Подробные [графики очереди std]({link}&queue={queue}&service={service}&cluster={cluster}) и других".format(
                    link=bsexport_queue_templated.get_link(),
                    queue='std',
                    service=queue_service.name,
                    cluster=jobs_prod.name,
                ),
            ),
        ]),
        Row(panels=[
            Panel(
                title="Всего кампаний в очереди",
                url=bs_export_campaigns_count.build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'norm': 'false',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
            ),
            Panel(
                title="Очередь BUGGY",
                subtitle="число кампаний и перцентили возраста",
                url=buggy_graph.get_dashboard_link(use_legend=False),
            ),
            Panel(
                title="Всего клиентов в очереди",
                url=bs_export_clients_count.build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'norm': 'false',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
            ),
        ]),
        Row(panels=[
            Panel(
                title="Распределение клиентов по максимальному времени в очереди",
                url=bs_export_clients_count.build_sensor_link(
                    parameters={
                        'stack': 'true',
                        'norm': 'true',
                        'cs': 'gradient',
                    },
                    full_link=False
                ),
                rowspan=2,
            ),
            Panel(
                title="Остальные очереди",
                subtitle="число кампаний",
                url=other_camps_graph.get_dashboard_link(use_legend=False),
            ),
            Panel(
                title="Отправлено объектов",
                subtitle="через logboker",
                url=logbroker_sent_objects.get_dashboard_link(use_legend=False),
                rowspan=2,
            ),
        ]),
        Row(panels=[
            Panel(
                title="Клиентов с отставанием более 90 минут",
                url=all_queue_delayed_clients_percent.get_dashboard_link(use_legend=False, parametrise={'queue': '-'}),
            ),
        ]),
    ],
    height_multiplier=1.0,
)


exports=[
    bsexport_common,
    bsexport_queue_templated,
]
