from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel

from direct.solo.registered.project import projects
from direct.solo.registered.sensors.requests_stat import ResponseTimeSensor, AwacsRpsSensor, Awacs5xxSensor

rps_sensor = AwacsRpsSensor(cluster='canvas-back.direct.yandex.net')
rps_5xx_sensor = Awacs5xxSensor(cluster='canvas-back.direct.yandex.net')
response_time = ResponseTimeSensor(cluster='canvas-back.direct.yandex.net')

RPS_PARAMS = dict(
    stack='false',
    min='0',
)
RESPONSE_TIME_PARAMS = dict(
    overLinesTransform='WEIGHTED_PERCENTILE',
    percentiles='50,90,95,99',
    threshold='25',
    legend='true',
)


canvas_dashboard = Dashboard(
    id='direct-canvas',
    project_id=projects.direct.id,
    name='direct-canvas',
    parameters=set(),
    rows=[
        Row(panels=[
            Panel(
                title="RPS",
                url=rps_sensor.build_sensor_link(parameters=RPS_PARAMS, full_link=False),
            ),
            Panel(
                title='Время ответа',
                url=response_time.build_sensor_link(parameters=RESPONSE_TIME_PARAMS, full_link=False),
            ),
        ]),
        Row(panels=[
            Panel(
                title="5xx RPS",
                url=rps_5xx_sensor.build_sensor_link(parameters=RPS_PARAMS, full_link=False),
            ),
            Panel(
                title='Время ответа, p95',
                url=response_time.build_sensor_link(
                    parameters={
                        'overLinesTransform': 'WEIGHTED_PERCENTILE',
                        'percentiles': '95',
                        'threshold': '25',
                        'legend': 'false',
                    },
                    full_link=False
                ),
            ),
        ]),
        Row(panels=[
            Panel(
                title="YT dumper fail",
                url='https://grafana.yandex-team.ru/d/nBirJEDZk/canvas-monitoring?orgId=1&from=now-2d&to=now&fullscreen&panelId=16',
            ),
            Panel(
                title='YT dumper time',
                url='https://grafana.yandex-team.ru/d/nBirJEDZk/canvas-monitoring?orgId=1&from=now-2d&to=now&fullscreen&panelId=17',
            ),
        ]),
    ],
    height_multiplier=1.0,
)


exports = [
    canvas_dashboard,
]
