# -*- coding: utf-8 -*-
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel
from direct.solo.registered import config
from direct.solo.registered.project import projects


def build_sensor_link(sensor):
    params = dict(cs="default", interpolate="linear")
    return sensor.build_sensor_link(parameters=params, full_link=False)


def build_sensor_for_shard(shard_id):
    sensor = Sensor(
        project='solomon',
        cluster='production',
        service='coremon',
        host='Sas',
        projectId='direct',
        sensor='engine.fileSensors|engine.fileSensorsLimit',
        shardId=shard_id,
        stack='false',
        )
    return sensor


PARAMETRISE = {
}


def generate_row(graphs):
    parametrize = PARAMETRISE
    return Row(
        panels=[
            Panel(
                url=graph.get_dashboard_link(parametrise=parametrize),
                title=graph.name
            ) for graph in graphs
        ]
    )


rows = []

for shard in config.SOLOMON_SHARDS:
    rows.append(
        Row(
            panels=[
                Panel(
                    title=shard,
                    url=build_sensor_link(
                        build_sensor_for_shard(shard)
                        )
                    )
                ]
            )
        )

solomon_quota_dashboard = Dashboard(
    id='solomon_quota_dashboard',
    project_id=projects.direct.id,
    name='Solomon Quota (Solo)',
    parameters=set(),
    rows=rows,
    height_multiplier=1
)

exports = [solomon_quota_dashboard]
