from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Parameter, Panel, Row
from direct.solo.registered.project import projects
from direct.solo.registered.sensors.balancer import backend_all
from direct.solo.registered.sensors.frontend import DirectBalancers


def build_sensor_link(sensor):
    params = dict(cs="default", interpolate="linear")
    return sensor.build_sensor_link(parameters=params, full_link=False)


direct_frontend_requests = Dashboard(
    id="direct_awacs_dashboard",
    project_id=projects.yabs.id,
    name="Direct balancer",
    parameters={
        Parameter(name="host", value="*"),
        Parameter(name="cluster", value="*"),
    },
    rows=[
        Row(
            panels=[
                Panel(
                    title=f"meta {cluster} requests",
                    url=build_sensor_link(
                        backend_all
                    )
                ),
            ]
        ) for cluster in [
            DirectBalancers.API,
            DirectBalancers.CANVAS,
        ]
    ]
)


exports = [
    direct_frontend_requests,
]
