from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel

from direct.solo.registered.graph.mdb import master_cpu_usage_graph
from direct.solo.registered.project import projects
from direct.solo.registered.sensors.requests_stat import ResponseTimeSensor, AwacsRpsSensor, Awacs5xxSensor

rps_all_sensor=AwacsRpsSensor(cluster='direct.yandex.ru|api.direct.yandex.ru')
rps_5xx_sensor=Awacs5xxSensor(cluster='direct.yandex.ru|api.direct.yandex.ru|intapi.direct.yandex.ru')
web_response_time=ResponseTimeSensor(cluster='direct.yandex.ru')
api_response_time=web_response_time.mutate(cluster='api.direct.yandex.ru')

RESPONSE_TIME_PARAMS=dict(
    overLinesTransform='WEIGHTED_PERCENTILE',
    percentiles='50,80,90,95,98,99',
    threshold='25',
    legend='true',
)

health_tags=[
    'direct-apps-health',
    'direct-resources',
    'direct-subsystems-health',
    'direct-baking-systems-health',
]

sre_dashboard = Dashboard(
    id='direct-group-sre-tv',
    project_id=projects.direct.id,
    name='direct-group-sre-tv',
    parameters=set(),
    rows=[
        Row(panels=[
            Panel(
                title='juggler',
                subtitle='tv',
                url='https://juggler.yandex-team.ru/aggregate_checks/?query=tag=directadmin_TV&limit=32&view=tiles&iframe=true',
                colspan=1,
                rowspan=3
            ),
            Panel(
                title="Запросы в интерфейс и апи",
                subtitle='rps, log scale',
                url=rps_all_sensor.build_sensor_link(
                    parameters={
                        'stack': 'false',
                        'scale': 'log',
                        'downsamplingAggr': 'max',
                    },
                    full_link=False
                ),
            ),
            Panel(
                title="5xx ошибки",
                subtitle='rps: интерфейс, апи, интапи',
                url='?project=direct&host=CLUSTER&service=awacs&graph=5xx_dashboard',
            ),
        ]),
        Row(panels=[
            Panel(
                title='Время ответа интерфейса',
                url=web_response_time.build_sensor_link(parameters=RESPONSE_TIME_PARAMS, full_link=False),
            ),
            Panel(
                title='Время ответа API',
                url=api_response_time.build_sensor_link(parameters=RESPONSE_TIME_PARAMS, full_link=False),
            ),
        ]),
        Row(panels=[
            Panel(
                title="ppcdata cpu usage",
                subtitle='top5, в процентах',
                url=master_cpu_usage_graph.get_dashboard_link() + '&filter=TOP&filterBy=MAX&filterLimit=5',
            ),
            Panel(
                title='Direct Health',
                url='https://juggler.yandex-team.ru/aggregate_checks/?query=' + '|'.join(map(lambda t: 'tag=' + t, health_tags)) + '&view=tiles&iframe=true&frames=2',
            ),
        ]),
    ],
    height_multiplier=1.0,
)


exports=[
    sre_dashboard,
]
