from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel
from direct.solo.registered.project import projects

balancer_signals = [
    'report-service_total-succ',
    'report-service_total-requests',
    'report-service_total-fail',
    'report-service_total-inprog',
    'report-service_total-conn_timeout',
]

wordstat_dashboard = Dashboard(
    id='wordstat',
    project_id=projects.direct.id,
    name='wordstat #Solo',
    parameters=set(),
    rows=[
        Row(panels=[
            Panel(
                title='from balancer',
                subtitle='resps from balancer backends',
                url='?project=direct&cluster=awacs_wordstat.yandex.ru&service=awacs&l.sensor=%s&l.host=CLUSTER&graph=auto&stack=false' % '|'.join(balancer_signals),
            ),
            Panel(
                title="juggler",
                url='https://juggler.yandex-team.ru/aggregate_checks/?query=(service%3Dwordstat_app%26host%3Ddirect.prod_apps-health)' +
                    '%7Chost%3Ddirect.prod_slb.wordstat.yandex.ru&view=tiles&iframe=true&frames=2',
            ),
        ]),
        Row(panels=[
            Panel(
                title='resp codes app',
                url='?project=direct&cluster=wordstat&service=nginx-access&sensor=rps&host=Sas%7CVla%7CMan&graph=auto&response_code=!ALL',
            ),
            Panel(
                title='resp times app percentiles',
                url='?project=direct&cluster=wordstat&service=nginx-access&sensor=response_time&host=Sas%7CVla%7CMan&graph=auto' +
                    '&response_code=!ALL&overLinesTransform=PERCENTILE&percentiles=50%2C90%2C95%2C99',
            ),
        ]),
    ],
    height_multiplier=1.0,
)


exports=[
    wordstat_dashboard,
]
