# -*- coding: utf-8 -*-
from functools import partial
from itertools import islice
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel, Parameter

from direct.solo.registered import config
from direct.solo.registered.project import projects

ROW_SIZE = 4


def build_sensor_link(sensor):
    params = dict(cs="default", interpolate="linear")
    return sensor.build_sensor_link(parameters=params, full_link=False)


def build_sensor_operations(pool):
    sensor = Sensor(
        project='yt',
        cluster='{{yt_cluster}}',
        service='scheduler_pools',
        sensor='yt.scheduler.pools.total_operation_count|yt.scheduler.pools.max_operation_count',
        pool=pool,
        tree='physical|cloud',
        stack='false',
    )
    return sensor


def build_sensor_cpu(pool):
    sensor = Sensor(
        project='yt',
        cluster='{{yt_cluster}}',
        service='scheduler_operations',
        sensor='yt.scheduler.operations_by_user.resource_usage.cpu|yt.scheduler.operations_by_user.resource_demand.cpu',
        pool=pool,
        tree='physical|cloud',
        stack='false',
    )
    return sensor


def chunked(iterable, n):
    def take(n, iterable):
        return list(islice(iterable, n))

    return iter(partial(take, n, iter(iterable)), [])


rows = []
for pool_chunk in chunked(config.YT_POOLS, ROW_SIZE):
    panels = []
    for pool in pool_chunk:
        panel = Panel(
            title=f'Количество операций {pool}',
            url=build_sensor_link(build_sensor_operations(pool))
        )
        panels.append(panel)
    rows.append(Row(panels=panels))

for pool_chunk in chunked(config.YT_POOLS, ROW_SIZE):
    panels = []
    for pool in pool_chunk:
        panel = Panel(
            title=f'Потребление CPU {pool}',
            url=build_sensor_link(build_sensor_cpu(pool))
        )
        panels.append(panel)
    rows.append(Row(panels=panels))

rows.append(
    Row(
        panels=[
            Panel(
                title="Juggler",
                url="https://juggler.yandex-team.ru/aggregate_checks/?query=host%3Ddirect.prod_common%26"
                    "(service%3Dyt_operations_limit)&iframe=true",
                colspan=ROW_SIZE,
            )
        ]
    )
)

yt_stat_dashboard = Dashboard(
    id='yt_resources_dashboard',
    project_id=projects.direct.id,
    name='YT Resources (Solo)',
    parameters={Parameter(name='yt_cluster', value='*')},
    rows=rows,
    height_multiplier=1
)

exports = [yt_stat_dashboard]
