from library.python.monitoring.solo.objects.solomon.v2 import YpCluster
from direct.solo.registered.external_services.zookeeper import KazooClientDirectPpcback
from direct.solo.registered.project import projects
import yaml

APPS_CONFFILE_ZK = '/direct/direct-apps.conf.yaml'


ENV_NAMES_BY_PROJECT_ID = {
    projects.direct.id: ['production'],
    projects.direct_test.id: ['testing', 'devtest', 'dev7'],
}


def get_apps_conf():
    zk = KazooClientDirectPpcback()
    zk.start()
    apps_conf_yaml, _ = zk.get(APPS_CONFFILE_ZK)
    apps_conf = yaml.load(apps_conf_yaml, Loader=yaml.SafeLoader)
    return apps_conf


def get_apps_deploy_places():
    apps_conf = get_apps_conf()
    app_deploy_place = {}
    for app, app_conf in apps_conf.get('apps').items():
        stages = app_conf.get('yadeploy-stages', {})
        deploy_units = app_conf.get('yadeploy-deploy-unit', {})
        locations = app_conf.get('locations', [])
        app_deploy_place[app] = {}
        for env, stage in stages.items():
            app_deploy_place[app][env] = {
                'stage': stage,
                'deploy_unit': deploy_units.get(env),
                'locations': locations,
            }
    return app_deploy_place


def build_yp_cluster(stage, deploy_unit, locations):
    cluster = set()

    if not isinstance(stage, list):
        stage = [{'stage': stage}]

    for stage_item in stage:
        stage_name = stage_item['stage']
        stage_locations = stage_item.get('locations', locations)

        pod_set_id = f'{stage_name}.{deploy_unit}'
        for dc in stage_locations:
            cluster.add(YpCluster(pod_set_id=pod_set_id, cluster=dc, labels=set([f"dc={dc}"])))

    return cluster
