from library.python.monitoring.solo.objects.solomon.v2 import Element, Graph, Parameter

from direct.solo.registered.cluster.app_java_jobs import jobs_prod
from direct.solo.registered.project import projects
from direct.solo.registered.sensors.external_metrics import direct_banners_log_requests, bs_base_sent_objects
from direct.solo.registered.sensors.transport_queues import bs_export_campaigns_count, bs_export_max_queue_age, bs_export_buggy_sequence_age
from direct.solo.registered.sensors.transport_queues import bs_export_clients_count, BS_EXPORT_CRIT_DELAY
from direct.solo.registered.service.bs_export_queue import direct_bs_export_queue as queue_service


parameters={
    Parameter(name='cluster', value=jobs_prod.name),
    Parameter(name='service', value=queue_service.name),
}


def reqs_graph(id, name, description, sensor):
    success = sensor.mutate(interpreted_status='success')
    other = success.mutate(interpreted_status=("!=", 'success'))
    return Graph(
        id=id,
        project_id=projects.direct.id,
        parameters=set(),
        name=name + " #solo",
        description=description,
        elements={
            Element(
                title='{{interpreted_status}}',
                type="EXPRESSION",
                area=False,
                expression='{selectors} * 15'. format(selectors=success.selectors),
                color='rgb(146,219,0)',
            ),
            Element(
                title='{{interpreted_status}}',
                type="EXPRESSION",
                area=False,
                expression='{selectors} * 15'. format(selectors=other.selectors),
            ),
        },
        graph_mode='GRAPH',
        secondary_graph_mode='NONE',
        normalize=False,
        color_scheme='DEFAULT',
        scale='LOG',
        over_lines_transform='NONE',
        ignore_inf=False,
        filter='NONE',
        filter_by='AVG',
        transform='NONE',
        downsampling='AUTO',
        downsampling_aggr="SUM",
        max_points=0,
        hide_no_data=True,
    )


logbroker_requests_graph = reqs_graph(
    id='bsexport_requests_logbroker',
    name='Отправок данных для БК в logbroker',
    description='Количество запросов, отправленных в direct-banners-log',
    sensor=direct_banners_log_requests,
)


def queue_graph(queue):
    queue_sensor = bs_export_campaigns_count.mutate(queue=queue)
    age_sensor = bs_export_max_queue_age.mutate(queue=queue)
    age_name = "{{sensor}}"
    if queue == 'buggy':
        age_expr = age_sensor.mutate(shard='-').selectors
    else:
        age_expr = age_sensor.mutate(percentile='p80|p95|p100').selectors
        age_name += " {{percentile}}"

    elements={
        Element(
            title='{{sensor}}',
            type="EXPRESSION",
            area=True,
            expression='sum({selectors}) by queue'.format(selectors=queue_sensor.selectors),
            yaxis='LEFT',
            color='aliceblue',
        ),
        Element(
            title=age_name,
            type="EXPRESSION",
            area=False,
            expression=age_expr,
            yaxis='RIGHT',
        ),
    }
    if queue == 'buggy':
        elements.add(Element(
            title='{{sensor}}',
            type="EXPRESSION",
            area=False,
            expression='{selectors}'.format(selectors=bs_export_buggy_sequence_age.selectors),
            yaxis='RIGHT',
        ))
    return Graph(
        id='bsexport_{queue}_queue'.format(queue=queue),
        project_id=projects.direct.id,
        parameters=parameters,
        name="Состояние {queue} очереди экспорта #solo".format(queue=queue),
        description="Число кампаний (Left Y) и перцентили возраста в минутах (Right Y)",
        elements=elements,
        graph_mode='GRAPH',
        secondary_graph_mode='NONE',
        normalize=False,
        number_format='1|',
        color_scheme='DEFAULT',
        scale='NATURAL',
        over_lines_transform='NONE',
        ignore_inf=False,
        filter='NONE',
        filter_by='AVG',
        transform='NONE',
        downsampling='AUTO',
        downsampling_aggr="DEFAULT",
        max_points=0,
        hide_no_data=True,
    )

std_graph = queue_graph(queue='std')
heavy_graph = queue_graph(queue='heavy')
buggy_graph = queue_graph(queue='buggy')
other_camps_graph = Graph(
    id='bsexport_other_queue_campaigns',
    project_id=projects.direct.id,
    parameters=parameters,
    name="Количество кампаний в других очередях экспорта в БК #solo",
    elements={
        Element(
            title='{{queue}}',
            type="EXPRESSION",
            area=False,
            expression='sum({selectors}) by queue'.format(selectors=bs_export_campaigns_count.mutate(queue=('!=', 'std|buggy|heavy')).selectors),
        ),
    },
    min='0',
    graph_mode='GRAPH',
    secondary_graph_mode='NONE',
    normalize=False,
    number_format='0|',
    color_scheme='DEFAULT',
    scale='NATURAL',
    over_lines_transform='NONE',
    ignore_inf=False,
    filter='NONE',
    filter_by='AVG',
    transform='NONE',
    downsampling='AUTO',
    downsampling_aggr="DEFAULT",
    max_points=0,
    hide_no_data=True,
)

all_queue_delayed_clients_percent = Graph(
    id='bsexport_delayed_clients_percent',
    project_id=projects.direct.id,
    parameters={
        Parameter(name='cluster', value=jobs_prod.name),
        Parameter(name='service', value=queue_service.name),
        Parameter(name='queue', value='*|-'),
    },
    name="Процент клиентов в экспорте в БК с отставанием #solo",
    description='Доля клиентов в очереди экспорта в БК с отставанием выше {} минут'.format(BS_EXPORT_CRIT_DELAY),
    graph_mode='GRAPH',
    secondary_graph_mode='NONE',
    min='0',
    normalize=False,
    color_scheme='AUTO',
    scale='NATURAL',
    over_lines_transform='NONE',
    ignore_inf=False,
    filter='NONE',
    filter_by='AVG',
    transform='NONE',
    downsampling='AUTO',
    max_points=0,
    hide_no_data=False,
    elements={
        Element(
            title='процент от общего числа',
            type="EXPRESSION",
            area=False,
            expression="histogram_cdfp({delay}, inf(), {selectors})".format(
                delay=BS_EXPORT_CRIT_DELAY,
                selectors=bs_export_clients_count.mutate(queue="{{queue}}").selectors
            ),
            yaxis='RIGHT',
        ),
        Element(
            title='штук',
            type="EXPRESSION",
            area=False,
            expression="histogram_count({delay}, inf(), {selectors})".format(
                delay=BS_EXPORT_CRIT_DELAY,
                selectors=bs_export_clients_count.mutate(queue="{{queue}}").selectors
            ),
            yaxis='LEFT',
        ),
    }
)
# по этому графику рассчитывается bYDT
warden_delayed_clients_percent = Graph(
    id='warden_bsexport_delayed_clients_percent',
    project_id=projects.direct.id,
    parameters=set(),
    name="[Warden] Процент клиентов в экспорте в БК с отставанием",
    description='Доля клиентов в очереди экспорта в БК с отставанием выше {} минут'.format(BS_EXPORT_CRIT_DELAY),
    graph_mode='GRAPH',
    secondary_graph_mode='NONE',
    min='0',
    normalize=False,
    color_scheme='AUTO',
    scale='NATURAL',
    over_lines_transform='NONE',
    ignore_inf=False,
    filter='NONE',
    filter_by='AVG',
    transform='NONE',
    downsampling='AUTO',
    max_points=0,
    hide_no_data=False,
    elements={
        Element(
            title='percent',
            type="EXPRESSION",
            area=False,
            expression="histogram_cdfp({delay}, inf(), {selectors})".format(
                delay=BS_EXPORT_CRIT_DELAY,
                selectors=bs_export_clients_count.selectors
            ),
        ),
    }
)


def object_sent_graph(id, name, description, sensor):
    return Graph(
        id=id,
        project_id=projects.direct.id,
        parameters=set(),
        name=name,
        description=description,
        elements={
            Element(
                title='{{object_type}}',
                type="EXPRESSION",
                area=True,
                expression='{selectors} * 15'. format(selectors=sensor.selectors),
            ),
        },
        min='0',
        graph_mode='GRAPH',
        secondary_graph_mode='NONE',
        normalize=False,
        number_format='0|',
        color_scheme='DEFAULT',
        scale='NATURAL',
        over_lines_transform='NONE',
        ignore_inf=False,
        filter='NONE',
        filter_by='AVG',
        transform='NONE',
        downsampling='AUTO',
        downsampling_aggr="SUM",
        max_points=0,
        hide_no_data=True,
    )

logbroker_sent_objects = object_sent_graph(
    id='bsexport_object_sent_to_logbroker',
    name='Отправлено объектов для БК в logbroker',
    description='Количество объектов, отправленных в direct-banners-log',
    sensor=bs_base_sent_objects.mutate(sub_system="direct-banners-log"),
)

exports = [
    std_graph,
    heavy_graph,
    buggy_graph,
    other_camps_graph,
    logbroker_requests_graph,
    all_queue_delayed_clients_percent,
    warden_delayed_clients_percent,
    logbroker_sent_objects,
]
