# -*- coding: utf-8 -*-
from library.python.monitoring.solo.objects.solomon.v2 import Element, Selector
from direct.solo.registered.graph.direct_balancer.common import BalancerGraph
from direct.solo.registered.sensors import balancer


def get_backends_balancer_graph(label, sensors, title="{{name}}", **kwargs):
    return BalancerGraph(
        id="balancer_backends_{0}".format(label),
        name="Balancer Backends {0}".format(label),
        elements={
            Element(
                selectors={
                    Selector(name="sensor", value="{}".format(sensor.name))}
            ) for sensor in sensors
        },
        **kwargs
    )


stats = get_backends_balancer_graph(
    "stats",
    [balancer.backend_attempt,
     balancer.backend_keepalive_reused])
errors = get_backends_balancer_graph(
    "errors",
    [balancer.backend_fail,  # bad responses from l7 due to bad backend responses, part of "fail" metric
     balancer.backend_error,  # bad backend responses
     balancer.backend_timeout])
limited_attempts = get_backends_balancer_graph(
    "limited_attempts",
    [balancer.limited_backend_attempt])

processing_time_percentiles = BalancerGraph(
    id="balancer_processing_time_percentiles",
    name="Balancer Processing Time Percentiles",
    elements={
        Element(
            title="{{bin}}",
            type="EXPRESSION",
            expression="""
                group_by_labels({0}, "bin", v -> group_lines("sum", v))
                """.format(balancer.processing_time)
        )
    },
    over_lines_transform="WEIGHTED_PERCENTILE",
    percentiles="95,97,99,99.5,99.6,99.7"
)

exports = [stats, errors, processing_time_percentiles, limited_attempts]
