# -*- coding: utf-8 -*-
from library.python.monitoring.solo.objects.solomon.v2 import Parameter, Graph
from direct.solo.registered.project.projects import direct


class BalancerGraph:
    def __new__(cls, **kwargs):
        defaults = dict(
            project_id=direct.id,
            parameters={Parameter(name='cluster', value='*'),
                        Parameter(name='service', value='*'),
                        Parameter(name='host', value='*')},
            graph_mode='GRAPH',
            secondary_graph_mode='PIE',
            min='0',
            max='',
            normalize=False,
            color_scheme='AUTO',
            drop_nans=True,
            stack=True,
            aggr='SUM',
            interpolate='LINEAR',
            scale='NATURAL',
            over_lines_transform='NONE',
            ignore_inf=False,
            filter='NONE',
            filter_by='AVG',
            transform='NONE',
            downsampling='AUTO',
            downsampling_aggr='MAX',
            grid='',
            max_points=0,
            hide_no_data=False,
        )
        for key, value in defaults.items():
            if key not in kwargs:
                kwargs[key] = value
        return Graph(**kwargs)
