# -*- coding: utf-8 -*-
from direct.solo.registered.sensors import balancer

from library.python.monitoring.solo.objects.solomon.v2 import Element, Selector
from direct.solo.registered.graph.direct_balancer.common import BalancerGraph


def get_connections_balancer_graph(label, sensors, use_contour=True):
    return BalancerGraph(
        id='balancer_connections_{0}'.format(label),
        name='Balancer Connections {0}'.format(label),
        elements={
            Element(
                selectors={
                    Selector(name='sensor', value='{}'.format(sensor.name))}
            ) for sensor in sensors
        }
    )


def get_http2_connections_balancer_graph(label, sensors):
    return BalancerGraph(
        id='balancer_connections_{0}'.format(label),
        name='Balancer Connections {0}'.format(label),
        elements={
            Element(
                selectors={
                    Selector(name='sensor', value='{}'.format(sensor.name))}
            ) for sensor in sensors
        }
    )


errors = get_connections_balancer_graph('errors', [balancer.connections_fail,
                                                   balancer.connections_refused,
                                                   balancer.connections_timeout])
stats = get_connections_balancer_graph('stats', [balancer.connections_in_progress])

http2_stats = get_http2_connections_balancer_graph('http2_stats', [balancer.http2_h1_conn_inprog,
                                                                   balancer.http2_h2_conn_inprog])

exports = [stats, errors, http2_stats]
