# -*- coding: utf-8 -*-
from direct.solo.registered.sensors import balancer

from library.python.monitoring.solo.objects.solomon.v2 import Element, Selector
from direct.solo.registered.graph.direct_balancer.common import BalancerGraph


def get_general_balancer_graph(label, sensors):
    return BalancerGraph(
        id='balancer_general_{0}'.format(label),
        name='Balancer General {0}'.format(label),
        elements={
            Element(
                selectors={
                    Selector(name='sensor', value='{}'.format(sensor.name))}
            ) for sensor in sensors
        }
    )


stats = get_general_balancer_graph('stats', [balancer.requests,
                                             balancer.success,
                                             balancer.fail])
connections = get_general_balancer_graph('connections', [balancer.reused,
                                                         balancer.not_reused,
                                                         balancer.keep_alive,
                                                         balancer.not_keep_alive])

exports = [stats, connections]
