# -*- coding: utf-8 -*-
from direct.solo.registered.sensors import balancer

from library.python.monitoring.solo.objects.solomon.v2 import Element, Selector
from direct.solo.registered.graph.direct_balancer.common import BalancerGraph


def get_http_balancer_graph(status, sensors):
    return BalancerGraph(
        id='balancer_outgoing_{0}'.format(status),
        name='Balancer HTTP {0}'.format(status),
        elements={
            Element(
                selectors={
                    Selector(name='sensor', value='{}'.format(sensor.name))}
            ) for sensor in sensors
        }
    )


outgoing_2xx = get_http_balancer_graph('2xx', [balancer.outgoing_200, balancer.outgoing_204])
outgoing_3xx = get_http_balancer_graph('3xx', [balancer.outgoing_301, balancer.outgoing_302, balancer.outgoing_307])
outgoing_4xx = get_http_balancer_graph('4xx', [balancer.outgoing_400, balancer.outgoing_401, balancer.outgoing_402,
                                               balancer.outgoing_403, balancer.outgoing_404, balancer.outgoing_405,
                                               balancer.outgoing_429])
outgoing_5xx = get_http_balancer_graph('5xx', [balancer.outgoing_500, balancer.outgoing_501, balancer.outgoing_502,
                                               balancer.outgoing_503, balancer.outgoing_504, balancer.outgoing_505])

exports = [outgoing_2xx, outgoing_3xx, outgoing_4xx, outgoing_5xx]
