# -*- coding: utf-8 -*-
from direct.solo.registered.sensors import balancer

from library.python.monitoring.solo.objects.solomon.v2 import Element, Selector
from direct.solo.registered.graph.direct_balancer.common import BalancerGraph


def get_general_balancer_graph(label, sensors):
    return BalancerGraph(
        id='balancer_ssl_{0}'.format(label),
        name='Balancer SSL {0}'.format(label),
        elements={
            Element(
                selectors={
                    Selector(name='sensor', value='{}'.format(sensor.name))}
            ) for sensor in sensors
        }
    )


stats = get_general_balancer_graph('stats', [balancer.ssl_sni_http_requests,
                                             balancer.ssl_sni_https_requests])
tls = get_general_balancer_graph('tls', [balancer.ssl_sni_tls1_0_requests,
                                         balancer.ssl_sni_tls1_1_requests,
                                         balancer.ssl_sni_tls1_2_requests,
                                         balancer.ssl_sni_tls1_3_requests])
errors = get_general_balancer_graph('errors', [balancer.ssl_sni_dropped_experiments,
                                               balancer.ssl_sni_empty_requests,
                                               balancer.ssl_sni_no_cipher_requests])

exports = [stats, tls, errors]
