# -*- coding: utf-8 -*-
from library.python.monitoring.solo.objects.solomon.v2 import Element
from direct.solo.registered.graph.direct_balancer.common import BalancerGraph

worker_cpu_usage = BalancerGraph(
    id='balancer_workers_cpu',
    name='Balancer Workers CPU',
    elements={
        Element(
            type='EXPRESSION',
            title='{{bin}}',
            expression="""
        group_by_labels({"bin"="*", "project"="adfox", "sensor"="worker-cpu_usage"}, 'bin', v -> group_lines('sum', v))
            """
        )
    },
    color_scheme='GRADIENT',
    normalize=True
)

exports = [worker_cpu_usage]
