from library.python.monitoring.solo.objects.solomon.v2 import Element, Graph, Parameter
from library.python.monitoring.solo.objects.solomon.sensor import Sensor

from direct.solo.registered.alert.infra.mdb.mysql.common import CONNECTED_THREADS_PPCDICT_WARN_THRESHOLD, CONNECTED_THREADS_PPCDICT_CRIT_THRESHOLD
from direct.solo.registered.alert.infra.mdb.mysql.common import CONNECTED_THREADS_WARN_THRESHOLD, CONNECTED_THREADS_CRIT_THRESHOLD
from direct.solo.registered.cluster import mysql
from direct.solo.registered.project import projects
from direct.solo.registered.sensors.mdb import MdbSensor, MdbByHostSensor, mysql_threads_connected


PARAMETERS_PCS = {
    Parameter(name='project', value=projects.mdb.id),
    Parameter(name='cluster', value='*'),
    Parameter(name='host', value='*'),
}
PARAMETERS_ALL=PARAMETERS_PCS.copy()
PARAMETERS_ALL.add(Parameter(name='node', value='*'))
PARAMETERS_ALL.add(Parameter(name='dc', value='*'))

COMMON_PARAMS=dict(
    graph_mode='GRAPH',
    secondary_graph_mode='NONE',
    normalize=False,
    color_scheme='DEFAULT',
    scale='NATURAL',
    over_lines_transform='NONE',
    ignore_inf=False,
    filter='NONE',
    filter_by='AVG',
    transform='NONE',
    downsampling='AUTO',
    downsampling_aggr="DEFAULT",
    max_points=0,
    hide_no_data=True,
)

base_sensor = MdbSensor(cluster='{{cluster}}')
tx_sensor = base_sensor.mutate(sensor='/porto/net_tx_bytes')
rx_sensor = base_sensor.mutate(sensor='/porto/net_rx_bytes')
net_limit_sensor = base_sensor.mutate(sensor='/porto/net_limit')
net_guarantee_sensor = base_sensor.mutate(sensor='/porto/net_guarantee')

net_graph = Graph(
    id='mdb_network',
    project_id=projects.direct.id,
    parameters=PARAMETERS_ALL,
    name="Утилизация сети в MDB #solo",
    description='Использование сети, в байтах',
    elements={
        Element(
            title='TX {{container}}',
            type="EXPRESSION",
            area=False,
            expression=tx_sensor.selectors,
        ),
        Element(
            title='RX {{container}}',
            type="EXPRESSION",
            area=False,
            expression=rx_sensor.selectors,
        ),
        Element(
            title='Guarantee',
            type="EXPRESSION",
            expression='series_avg({})'.format(net_guarantee_sensor.selectors),
            area=False,
            color='yellow',
        ),
        Element(
            title='Limit',
            type="EXPRESSION",
            expression='series_avg({})'.format(net_limit_sensor.selectors),
            area=False,
            color='red',
        ),
    },
    **COMMON_PARAMS
)

cpu_wait_sensor = base_sensor.mutate(sensor='/porto/cpu_wait')
cpu_system_sensor = base_sensor.mutate(sensor='/porto/cpu_usage_system')
cpu_user_sensor = base_sensor.mutate(sensor='/porto/cpu_usage')
cpu_limit_sensor = base_sensor.mutate(sensor='/porto/cpu_limit')
cpu_guarantee_sensor = base_sensor.mutate(sensor='/porto/cpu_guarantee')

cpu_graph = Graph(
    id='mdb_cpu',
    project_id=projects.direct.id,
    parameters=PARAMETERS_ALL,
    name="Потребление CPU в MDB #solo",
    description='Потребление CPU, в ядрах',
    elements={
        Element(
            title='Userspace',
            type="EXPRESSION",
            expression=cpu_user_sensor.selectors,
            area=False,
            color='cyan',
        ),
        Element(
            title='System',
            type="EXPRESSION",
            expression=cpu_system_sensor.selectors,
            area=False,
            color='green',
        ),
        Element(
            title='Wait',
            type="EXPRESSION",
            expression=cpu_wait_sensor.selectors,
            area=False,
            color='orange',
        ),
        Element(
            title='Guarantee',
            type="EXPRESSION",
            expression='series_avg({})'.format(cpu_guarantee_sensor.selectors),
            area=False,
            color='yellow',
        ),
        Element(
            title='Limit',
            type="EXPRESSION",
            expression='series_avg({})'.format(cpu_limit_sensor.selectors),
            area=False,
            color='red',
        ),
    },
    **COMMON_PARAMS
)

queries_sensor=base_sensor.mutate(sensor='mysql_Queries_rate')
threads_sensor=base_sensor.mutate(sensor='mysql_Threads_running')
slow_queries_sensor=base_sensor.mutate(sensor='mysql_Slow_queries_rate')
avg_query_time_sensor=base_sensor.mutate(sensor='mysql_latency_query_avg')
threads_connected_sensor=base_sensor.mutate(sensor='mysql_Threads_connected')
disk_usage_mysql_data_sensor=base_sensor.mutate(sensor='disk-used_bytes_mysql_data')
master_cpu_usage_elements=set()
ppcdata_master_cpu_usage_elements=set()
ppcdata_master_queries_elements=set()
ppcdata_master_threads_elements=set()
ppcdata_master_slow_queries_elements=set()
ppcdata_master_avg_query_time_elements=set()
ppcdata_master_threads_connected_elements=set()
ppcdata_master_disk_usage_mysql_data_elements=set()
ppcdata_master_binlog_age_elements=set()
for (name, cluster_id) in mysql.production.items():
    labels=dict(
        cluster='mdb_' + cluster_id,
        host='by_node',
        dc='by_node',
        node='primary',
    )
    master_cpu_usage_element=Element(
        title=name,
        type='EXPRESSION',
        area=False,
        expression='100 * {usage} / {guarantee}'.format(
            usage=cpu_user_sensor.mutate(**labels).selectors,
            guarantee=cpu_guarantee_sensor.mutate(**labels).selectors,
        ),
    )
    master_cpu_usage_elements.add(master_cpu_usage_element)
    if name.startswith('ppcdata'):
        ppcdata_master_cpu_usage_elements.add(master_cpu_usage_element)
        ppcdata_master_queries_elements.add(Element(
            title=name,
            type='EXPRESSION',
            area=False,
            expression=queries_sensor.mutate(**labels).selectors,
        ))
        ppcdata_master_threads_elements.add(Element(
            title=name,
            type='EXPRESSION',
            area=False,
            expression=threads_sensor.mutate(**labels).selectors,
        ))
        ppcdata_master_threads_connected_elements.add(Element(
            title=name,
            type='EXPRESSION',
            area=False,
            expression=threads_connected_sensor.mutate(**labels).selectors,
        ))
        ppcdata_master_slow_queries_elements.add(Element(
            title=name,
            type='EXPRESSION',
            area=False,
            expression=slow_queries_sensor.mutate(**labels).selectors,
        ))
        ppcdata_master_avg_query_time_elements.add(Element(
            title=name,
            type='EXPRESSION',
            area=False,
            expression=avg_query_time_sensor.mutate(**labels).selectors,
        ))
        ppcdata_master_disk_usage_mysql_data_elements.add(Element(
            title=name,
            type='EXPRESSION',
            area=False,
            expression=disk_usage_mysql_data_sensor.mutate(**labels).selectors,
        ))

        # так именуются в mysql-binlog-age-check https://a.yandex-team.ru/arcadia/direct/infra/go-libs/pkg/dbconfig/dbconfig.go?rev=r9636231#L303
        binlog_age_instance_name = name.replace('ppcdata', 'ppc')
        binlog_age_sensor = Sensor(
            project="direct",
            cluster="*",
            service="mysql-binlog-age-monitoring",
            instance=binlog_age_instance_name,
            host="CLUSTER",
            environment="production",
            value="mysql_binlog_age"
        )
        ppcdata_master_binlog_age_elements.add(Element(
            title=name,
            type='EXPRESSION',
            area=False,
            expression='{} / 86400'.format(binlog_age_sensor),
        ))

master_cpu_usage_graph = Graph(
    id='mdb_cpu_usage',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Утилизация CPU на мастерах MySQL #solo",
    description='Утилизация CPU на мастерах MySQL в MDB, проценты',
    elements=master_cpu_usage_elements,
    min='0',
    max='100',
    stack=False,
    **COMMON_PARAMS
)

ppcdata_master_cpu_usage_graph = Graph(
    id='ppcdata_mdb_cpu_usage',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Утилизация CPU на мастерах шардов MySQL #solo",
    description='Утилизация CPU на мастерах шардов MySQL в MDB, проценты',
    elements=ppcdata_master_cpu_usage_elements,
    min='0',
    max='100',
    stack=False,
    **COMMON_PARAMS
)
ppcdata_master_queries_graph = Graph(
    id='ppcdata_mdb_queries',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Запросы на мастерах шардов MySQL #solo",
    description='Запросы на мастерах шардов MySQL в MDB',
    elements=ppcdata_master_queries_elements,
    stack=False,
    **COMMON_PARAMS
)
ppcdata_master_threads_graph = Graph(
    id='ppcdata_mdb_threads',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Работающие потоки на мастерах шардов MySQL #solo",
    description='Работающие потоки на мастерах шардов MySQL в MDB',
    elements=ppcdata_master_threads_elements,
    stack=False,
    **COMMON_PARAMS
)
ppcdata_master_threads_connected_graph = Graph(
    id='ppcdata_mdb_threads_connected',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Соединения на мастерах шардов MySQL #solo",
    description='Соединения на мастерах шардов MySQL в MDB',
    elements=ppcdata_master_threads_connected_elements,
    stack=False,
    **COMMON_PARAMS
)
ppcdata_master_slow_queries_graph = Graph(
    id='ppcdata_mdb_slow_queries',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Медленные запросы на мастерах шардов MySQL #solo",
    description='Медленные запросы на мастерах шардов MySQL в MDB',
    elements=ppcdata_master_slow_queries_elements,
    stack=False,
    **COMMON_PARAMS
)
ppcdata_master_avg_query_time_graph = Graph(
    id='ppcdata_mdb_avg_query_time',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Среднее время запроса на мастерах шардов MySQL #solo",
    description='Среднее время запроса на мастерах шардов MySQL в MDB',
    elements=ppcdata_master_avg_query_time_elements,
    stack=False,
    **COMMON_PARAMS
)
ppcdata_mdb_disk_usage_mysql_data_graph = Graph(
    id='ppcdata_mdb_disk_usage_mysql_data',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.mdb.id)},
    name="Занятое данными место на мастерах шардов MySQL #solo",
    description='Занятое данными место на мастерах шардов MySQL в MDB',
    elements=ppcdata_master_disk_usage_mysql_data_elements,
    stack=False,
    **COMMON_PARAMS
)
ppcdata_master_binlog_age_graph = Graph(
    id='ppcdata_binlog_age',
    project_id=projects.direct.id,
    parameters={Parameter(name='project', value=projects.direct.id)},
    name="Возраст первой записи в бинлоге (в днях) на мастерах шардов MySQL #solo",
    description='Возраст первой записи в бинлоге (в днях) на мастерах шардов MySQL',
    elements=ppcdata_master_binlog_age_elements,
    stack=False,
    **COMMON_PARAMS
)

disk_free_sensor = MdbByHostSensor(cluster='{{cluster}}', sensor='disk-free_bytes_/var/lib/mysql')
disk_limit_sesnor = disk_free_sensor.mutate(sensor='disk-total_bytes_/var/lib/mysql')

disk_free_graph = Graph(
    id='mdb_disk_free',
    project_id=projects.direct.id,
    parameters=PARAMETERS_PCS,
    name="MDB disk free space #solo",
    description='Disk free space, in bytes',
    elements={
        Element(
            title='{{host}}',
            type="EXPRESSION",
            expression=disk_free_sensor.selectors,
            area=False,
        ),
        Element(
            title='RO Threshold {{host}}',
            type="EXPRESSION",
            expression='0.05 * {}'.format(disk_limit_sesnor.selectors),     # 5% — копипаста из деша MDB
            # https://solomon.yandex-team.ru/?cluster=mdb_mdblalcapob1thamfgn2&project=internal-mdb&service=mdb&dashboard=internal-mdb-cluster-mysql
            area=False,
            color='red',
        ),
    },
    min='0',
    **COMMON_PARAMS
)

disk_limit_sensor = base_sensor.mutate(sensor='/porto/io_limit')
disk_read_sensor = base_sensor.mutate(sensor='/porto/io_read')
disk_write_sensor = base_sensor.mutate(sensor='/porto/io_write')

disk_io_graph=Graph(
    id='mdb_disk_io',
    project_id=projects.direct.id,
    parameters=PARAMETERS_ALL,
    name="MDB disk IO #solo",
    description='Disk IO, in bytes',
    elements={
        Element(
            title='Read {{container}}',
            type="EXPRESSION",
            expression=disk_read_sensor.selectors,
            area=False,
        ),
        Element(
            title='Write {{container}}',
            type="EXPRESSION",
            expression=disk_write_sensor.selectors,
            area=False,
        ),
        Element(
            title='Limit',
            type="EXPRESSION",
            expression='series_avg({})'.format(disk_limit_sensor.selectors),
            area=False,
            color='red',
        ),
    },
    **COMMON_PARAMS
)


def get_connections_treshold_expr(ppcdict, ppcdata, sandbox):
    return '''
        constant_line(get_label({selectors}, 'cluster') == '{ppcdict}'
            ? {ppcdict_value}
            : (get_label({selectors}, 'cluster') == '{sandbox}'
                    ? {sandbox_value}
                    : {ppc_value}
            )
        )
    '''.format(
        selectors=mysql_threads_connected.selectors,
        ppcdict='mdb_'+mysql.production['ppcdict'],
        sandbox='mdb_'+mysql.sandbox,
        ppcdict_value=ppcdict,
        sandbox_value=sandbox,
        ppc_value=ppcdata,
    )

SB_MAX_CONNS = 400
mysql_threads_connected_graph = Graph(
    id='mdb_mysql_connected_threads',
    project_id=projects.direct.id,
    parameters=PARAMETERS_PCS,
    name="MDB MySQL Connected threads",
    elements={
        Element(
            title='{{host}}',
            type='EXPRESSION',
            expression=mysql_threads_connected.selectors,
            area=False,
        ),
        Element(
            title='warn threshold',
            type="EXPRESSION",
            expression=get_connections_treshold_expr(CONNECTED_THREADS_PPCDICT_WARN_THRESHOLD, CONNECTED_THREADS_WARN_THRESHOLD, 0.5*SB_MAX_CONNS),
            color='yellow',
            area=False,
        ),
        Element(
            title='crit threshold',
            type="EXPRESSION",
            expression=get_connections_treshold_expr(CONNECTED_THREADS_PPCDICT_CRIT_THRESHOLD, CONNECTED_THREADS_CRIT_THRESHOLD, 0.8*SB_MAX_CONNS),
            color='red',
            area=False,
        ),
    },
    **COMMON_PARAMS
)

exports = [
    net_graph,
    cpu_graph,
    master_cpu_usage_graph,
    ppcdata_master_cpu_usage_graph,
    ppcdata_master_queries_graph,
    ppcdata_master_slow_queries_graph,
    ppcdata_master_threads_graph,
    ppcdata_master_threads_connected_graph,
    ppcdata_master_avg_query_time_graph,
    ppcdata_mdb_disk_usage_mysql_data_graph,
    ppcdata_master_binlog_age_graph,
    disk_free_graph,
    disk_io_graph,
    mysql_threads_connected_graph,
]
