from library.python.monitoring.solo.objects.solomon.v2 import Element, Graph, Parameter

from direct.solo.registered.cluster.app_java_jobs import jobs_prod
from direct.solo.registered.project.projects import direct
from direct.solo.registered.sensors.ess import aggregated_statuses_delay
from direct.solo.registered.service.java_monitoring import java_monitoring

delayInMin = 30
delay = 60 * delayInMin

sensor = aggregated_statuses_delay.selectors

warden_aggregated_statuses_delayed_shards = Graph(
    id='warden_aggregated_statuses_delayed_shards',
    project_id=direct.id,
    parameters={Parameter(name='cluster', value=jobs_prod.name),
                Parameter(name='service', value=java_monitoring.name),
                },
    name="[Warden] aggregated statuses delayed shards percent #solo",
    description='Доля шардов с отставанием статусов выше {} минут'.format(delayInMin),
    graph_mode='GRAPH',
    secondary_graph_mode='NONE',
    min='0',
    max='',
    normalize=False,
    color_scheme='AUTO',
    drop_nans=False,
    stack=False,
    aggr='AVG',
    interpolate='RIGHT',
    scale='NATURAL',
    over_lines_transform='NONE',
    ignore_inf=False,
    filter='NONE',
    filter_by='AVG',
    transform='NONE',
    downsampling='AUTO',
    max_points=0,
    hide_no_data=False,
    elements={
        Element(
            title='percent',
            type="EXPRESSION",
            area=False,
            expression="group_lines('sum', map({}, x -> heaviside(x - {}))) / size({}) * 100".format(sensor, delay, sensor)
        )
    }
)

exports = [warden_aggregated_statuses_delayed_shards]
