from juggler_sdk import Check, Child
from direct.solo.registered.external_services.zookeeper import KazooClientDirectPpcback
import yaml

AWACS_API_NAMESPACE = 'api.direct.yandex.ru'
AWACS_CANVAS_BACK_NAMESPACE = 'canvas-back.direct.yandex.net'
AWACS_WEB_NAMESPACE = 'direct.yandex.ru'
AWACS_INTAPI_NAMESPACE = 'intapi.direct.yandex.ru'

awacs_namespaces = [
    AWACS_API_NAMESPACE,
    AWACS_CANVAS_BACK_NAMESPACE,
    AWACS_WEB_NAMESPACE,
    AWACS_INTAPI_NAMESPACE,
]

checks = []
zk = KazooClientDirectPpcback()
zk.start()
vhosts_config_yaml, _ = zk.get('/direct/direct-vhosts.yaml')
vhosts_config = yaml.load(vhosts_config_yaml, Loader=yaml.SafeLoader)
for awacs_namespace in awacs_namespaces:
    vhost = awacs_namespace     # рассчитываем, что совпадают
    try:
        juggler_hosts = vhosts_config["vhosts"][vhost]["l7_balancers"]["juggler_hosts"]
    except KeyError:
        juggler_hosts = []
    for juggler_service in ['health-check-instances', 'check-enddate-certificate-instances', 'check-balancer-zombie-procs-instances']:
        checks.append(Check(
            namespace="direct.prod",
            host=awacs_namespace,
            service=juggler_service,
            refresh_time=90, ttl=900,
            aggregator="logic_or",
            tags=[],
            children=[Child(
                service=juggler_service,
                group_type='HOST',
                host=h
            ) for h in juggler_hosts]
        ))

exports = checks
