from urllib.parse import urlparse, parse_qs
from juggler_sdk import Check, Child
from direct.solo.registered.external_services.apps_conf import get_apps_conf
from direct.solo.registered.juggler import reference

CI_SERVICE = 'direct'

checks = []

apps_conf = get_apps_conf()

for app, app_conf in apps_conf['apps'].items():
    new_ci_graph = app_conf.get('newci_graph')

    if new_ci_graph is not None:
        params = parse_qs(urlparse(new_ci_graph).query)
        release_id = params['id'][0]
        release_config_path = params['dir'][0]

        checks.append(Check(
            namespace=reference.NAMESPACE_NP,
            host="direct.np_release",
            service=app,
            refresh_time=90, ttl=900,
            aggregator="logic_or",
            tags=['direct-health-np'],
            children=[Child(
                host="ci-release-status-{}".format(CI_SERVICE),
                service=release_id,
                instance=release_config_path
            )]
        ))

exports = checks
