from juggler_sdk import NotificationOptions

NAMESPACE_PROD = "direct.prod"
NAMESPACE_TEST = "direct.test"
NAMESPACE_DEV = "direct.dev"
NAMESPACE_NP = "direct.np"

LOGIN_TEST_COORDINATION_CHAT = "direct_coordination_test"

JUGGLER_HISTORY = NotificationOptions(
    template_name='push',
    template_kwargs=dict(push_url='http://juggler-history.da.yandex.ru/save_notifications'),
    description='сервис для хранения истории по проверкам'
)

DUTY_ESCALATION = NotificationOptions(
    template_name='phone_escalation',
    template_kwargs={
        'on_success_next_call_delay': 90,
        'delay': 600,
        'logins': [
            '@svc_direct-app-duty:direct-production-duty',
            'robot-direct-admin',
            'pe4kin',
            'yukaba',
        ],
    },
    description='звонки',
)

LIGHT_DUTY_ESCALATION = NotificationOptions(
    template_name='phone_escalation',
    template_kwargs={
        'on_success_next_call_delay': 300,
        'delay': 3600,
        'logins': [
            '@svc_direct-app-duty:direct-production-duty',
            'robot-direct-admin',
            'robot-mtrs-duty',
        ],
        'time_start': '11:00',
        'time_end': '19:00',
    },
    description='звонки в дневное время для аварий средней критичности',
)

CALLING_CHECKS_CHAT = NotificationOptions(
    template_name='on_status_change',
    template_kwargs=dict(
        status=['CRIT'],
        method=['telegram'],
        login='Direct-Monitoring-Calls'
    ),
    description=u'чат для звонящих проверок',
)

DUTY_TS_TICKETS = NotificationOptions(
    template_name='startrek',
    template_kwargs={
        'delay': 600,
        'queue': 'DIRECT',
        'components': 'lifeline_monitoring_ts',
        'assignee': 'aleran'
    },
    description='создание тикетов на дежурных по ТС',
)


def get_warden_tags(slug, ydt=False, bydt=False, category='boolean', flow=True):
    tags=[
        'warden_alert_create_spi',
        'warden_auto_source',
        'warden_functionality_' + slug,
        'warden_alert_category_' + category,
    ]
    if flow:
        tags.append('warden_alert_start_flow')
    if ydt:
        tags.append('warden_alert_account_metric')
    if bydt:
        tags.append('warden_alert_account_background_metric')
    return tags


def get_namespace_by_env(env):
    if env == 'production' or env == 'prod':
        return NAMESPACE_PROD
    elif env == 'testing':
        return NAMESPACE_TEST
    else:
        return NAMESPACE_DEV
