from direct.solo.registered import config
from direct.solo.registered.juggler import reference
from juggler_sdk import Check, Child

shard_checks = []
for shard in config.SOLOMON_SHARDS:
    shard_url = 'https://solomon.yandex-team.ru/admin/projects/direct/shards/{}'.format(shard)
    shard_checks.append(Check(
        namespace=reference.NAMESPACE_PROD,
        host='direct.prod_resources.solomon',
        service='shard_' + shard,
        refresh_time=90, ttl=900,
        aggregator='logic_or',
        tags=[],
        children=[Child(
            group_type='HOST',
            host='direct_solomon_quota',
            service=shard,
        )],
        notifications=[reference.JUGGLER_HISTORY],
        meta={'urls': [
            {
                'title': 'Шард в Solomon',
                'url': shard_url,
            }
        ]},
    ))

top_check = Check(
    namespace=reference.NAMESPACE_PROD,
    host='direct.prod_resources',
    service='solomon',
    refresh_time=90, ttl=900,
    aggregator='logic_or',
    tags=['direct-resources'],
    children=[
        Child(
            host='direct.prod_resources.solomon',
            service='shard_' + shard,
        ) for shard in config.SOLOMON_SHARDS
    ],
    notifications=[reference.JUGGLER_HISTORY],
)

exports = shard_checks + [top_check]
