from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.cluster import clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service import services


class BalancerSensor(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(project=projects.direct.id,
                                 cluster=clusters.direct_api_balancer.name,
                                 service=services.direct_awacs.name,
                                 host='CLUSTER')
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        super().__init__(**other_labels)


outgoing_1xx = BalancerSensor(sensor='report-service_total-outgoing_1xx')

outgoing_2xx = BalancerSensor(sensor='report-service_total-outgoing_2xx')
outgoing_200 = BalancerSensor(sensor='report-service_total-outgoing_200')
outgoing_204 = BalancerSensor(sensor='report-service_total-outgoing_204')

outgoing_3xx = BalancerSensor(sensor='report-service_total-outgoing_3xx')
outgoing_301 = BalancerSensor(sensor='report-service_total-outgoing_301')
outgoing_302 = BalancerSensor(sensor='report-service_total-outgoing_302')
outgoing_307 = BalancerSensor(sensor='report-service_total-outgoing_307')

outgoing_4xx = BalancerSensor(sensor='report-service_total-outgoing_4xx')
outgoing_400 = BalancerSensor(sensor='report-service_total-outgoing_400')
outgoing_401 = BalancerSensor(sensor='report-service_total-outgoing_401')
outgoing_402 = BalancerSensor(sensor='report-service_total-outgoing_402')
outgoing_403 = BalancerSensor(sensor='report-service_total-outgoing_403')
outgoing_404 = BalancerSensor(sensor='report-service_total-outgoing_404')
outgoing_405 = BalancerSensor(sensor='report-service_total-outgoing_405')
outgoing_429 = BalancerSensor(sensor='report-service_total-outgoing_429')

outgoing_5xx = BalancerSensor(sensor='report-service_total-outgoing_5xx')
outgoing_500 = BalancerSensor(sensor='report-service_total-outgoing_500')
outgoing_501 = BalancerSensor(sensor='report-service_total-outgoing_501')
outgoing_502 = BalancerSensor(sensor='report-service_total-outgoing_502')
outgoing_503 = BalancerSensor(sensor='report-service_total-outgoing_503')
outgoing_504 = BalancerSensor(sensor='report-service_total-outgoing_504')
outgoing_505 = BalancerSensor(sensor='report-service_total-outgoing_505')

outgoing_all = BalancerSensor(sensor='report-service_total-outgoing_*xx')

# general
requests = BalancerSensor(sensor='report-engine_handler-requests')
reused = BalancerSensor(sensor='report-engine_handler-reused')
not_reused = BalancerSensor(sensor='report-engine_handler-nreused')
success = BalancerSensor(sensor='report-engine_handler-succ')
error = BalancerSensor(sensor='report-engine_handler-err', bin='*')
fail = BalancerSensor(sensor='report-engine_handler-fail')
keep_alive = BalancerSensor(sensor='report-engine_handler-ka')
not_keep_alive = BalancerSensor(sensor='report-engine_handler-nka')
processing_time = BalancerSensor(sensor='report-engine_handler-processing_time', bin='*')

# client
client_all = BalancerSensor(sensor='report-engine_handler-client_*')
client_error = BalancerSensor(sensor='report-engine_handler-client_error')
client_fail = BalancerSensor(sensor='report-engine_handler-client_fail')

# backends
backend_all = BalancerSensor(sensor='report-engine_handler-backend_*')
backend_attempt = BalancerSensor(sensor='report-engine_handler-backend_attempt')
backend_error = BalancerSensor(sensor='report-engine_handler-backend_error')
backend_fail = BalancerSensor(sensor='report-engine_handler-backend_fail')
backend_keepalive_reused = BalancerSensor(sensor='report-engine_handler-backend_keepalive_reused')
backend_time_bins = [0.1, 0.2, 0.3, 0.4, 0.5, 0.15, 0.75, 1, 1.5, 2, 2.5, 3, 'inf']
backend_time = BalancerSensor(sensor='report-engine_handler-backend_time', bin='*')
backend_timeout = BalancerSensor(sensor='report-engine_handler-backend_timeout')
limited_backend_attempt = BalancerSensor(sensor='report-engine_handler-limited_backend_attempt')

# connections
connections_in_progress = BalancerSensor(sensor='report-engine_handler-inprog')
connections_fail = BalancerSensor(sensor='report-engine_handler-conn_fail')
connections_other_error = BalancerSensor(sensor='report-engine_handler-conn_other_error')
connections_refused = BalancerSensor(sensor='report-engine_handler-conn_refused')
connections_timeout = BalancerSensor(sensor='report-engine_handler-conn_timeout')

# http2 stat
http2_h2_conn_inprog = BalancerSensor(sensor='http2-h2_conn_inprog')
http2_h1_conn_inprog = BalancerSensor(sensor='http2-h1_conn_inprog')

# ssl-sni
ssl_sni_http_requests = BalancerSensor(sensor='ssl_sni-http_requests')
ssl_sni_https_requests = BalancerSensor(sensor='ssl_sni-https_requests')
ssl_sni_tls1_0_requests = BalancerSensor(sensor='ssl_sni-tls1_0_requests')
ssl_sni_tls1_1_requests = BalancerSensor(sensor='ssl_sni-tls1_1_requests')
ssl_sni_tls1_2_requests = BalancerSensor(sensor='ssl_sni-tls1_2_requests')
ssl_sni_tls1_3_requests = BalancerSensor(sensor='ssl_sni-tls1_3_requests')
ssl_sni_ssl2_requests = BalancerSensor(sensor='ssl_sni-ssl2_requests')
ssl_sni_empty_requests = BalancerSensor(sensor='ssl_sni-empty_requests')
ssl_sni_no_cipher_requests = BalancerSensor(sensor='ssl_sni-no_cipher_requests')
ssl_sni_dropped_experiments = BalancerSensor(sensor='ssl_sni-dropped_experiments')

# system
worker_cpu_usage = BalancerSensor(sensor='worker-cpu_usage', bin='*')
