from library.python.monitoring.solo.objects.solomon.sensor import Sensor

from direct.solo.registered.cluster import clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service import services


class BinlogDelaySensor(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(project=projects.direct.id,
                                 cluster=clusters.jobs_prod.name,
                                 service=services.java_monitoring.name,
                                 sensor='binlog_delay',
                                 host='CLUSTER',
                                 env='production')
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        super().__init__(**other_labels)


aggregated_statuses_delay = BinlogDelaySensor(ess_processor="aggregated_statuses_updater", shard='*')


class LogbrokerReadDelayMsSensor(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(
            project="kikimr",
            cluster="lbkx",
            service="pqtabletAggregatedCounters",
            host="dc-unknown",
            OriginDC="*",
            sensor="CreateTimeLagMsByCommitted",
            Important="1",
            Account="direct",
        )
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        super().__init__(**other_labels)


aggregated_statuses_read_lag_ms = LogbrokerReadDelayMsSensor(
    TopicPath="direct/ess/aggregated-statuses_update-events",
    ConsumerPath="direct/ess/ess-consumer",
)

topics_excluded_from_common_alert = [
    # Сюда можно добавлять топики для их исключения из алёрта на отставание ESS
    "direct/ess/aggregated-statuses_update-events",  # aggr-statuses в отдельном алёрте
    "direct/grut-watchlog",  # в активной разработке
    "direct/ess/mysql2grut-replication",    # на Mysql2GrutReplicationProcessor висит PRIORITY_1
]

common_ess_topics_read_lag_ms = LogbrokerReadDelayMsSensor(
    TopicPath=("!=", "|".join(topics_excluded_from_common_alert)),
    ConsumerPath="direct/ess/ess-consumer",
)

important_bs_transport_topics = [
    "direct/ess/export-bs-ad-groups",
    "direct/ess/export-bs-banner-resources",
    "direct/ess/export-bs-biddable-show-conditions",
    "direct/ess/export-bs-campaigns",
    "direct/ess/export-bs-multipliers",
    "direct/ess/export-bs-meaningful-goals",
]

bs_transport_read_lag_ms = LogbrokerReadDelayMsSensor(
    TopicPath="|".join(important_bs_transport_topics),
    ConsumerPath="direct/ess/ess-consumer",
)

mysql2grut_replication_read_lag_ms = LogbrokerReadDelayMsSensor(
    TopicPath="direct/ess/mysql2grut-replication",
    ConsumerPath="direct/ess/ess-consumer",
)

moderation_export_topics = [
    "direct/ess/adgroup-moderation",
    "direct/ess/asset-moderation-callout",
    "direct/ess/asset-moderation-multicard",
    "direct/ess/asset-moderation-vcard",
    "direct/ess/asset-moderation-video_addition",
    "direct/ess/banner-button-moderation",
    "direct/ess/banner-logo-moderation",
    "direct/ess/banner-moderation-content_promotion",
    "direct/ess/banner-moderation-cpc_video",
    "direct/ess/banner-moderation-cpm_banner",
    "direct/ess/banner-moderation-dynamic",
    "direct/ess/banner-moderation-image_ad",
    "direct/ess/banner-moderation-internal_banner",
    "direct/ess/banner-moderation-mobile_content",
    "direct/ess/banner-moderation-performance_main",
    "direct/ess/banner-moderation-text",
    "direct/ess/bannerstorage-creatives-moderation",
    "direct/ess/displayhrefs-moderation",
    "direct/ess/image-moderation",
    "direct/ess/mobile-content-icon-moderation",
    "direct/ess/moderation-special-campaign-copy",
    "direct/ess/promoaction-moderation",
    "direct/ess/sitelinks-moderation",
    "direct/ess/turbolandings-moderation",
]

moderation_export_read_lag_ms = LogbrokerReadDelayMsSensor(
    TopicPath="|".join(moderation_export_topics),
    ConsumerPath="direct/ess/ess-consumer",
)
