from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.cluster import clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service import external_metrics as service


class BaseExternalMetric(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(project=projects.direct.id,
                                 cluster=clusters.intapi_prod.name,
                                 service=service.prod.name,
                                 host='CLUSTER',
                                 env='production')
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        super().__init__(**other_labels)


class RequestsCount(BaseExternalMetric):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'reqs.count'
        super().__init__(**other_labels)


metrika_requests=RequestsCount(external_system='metrika', method='*')
metrika_server_errors=metrika_requests.mutate(interpreted_status='server_error')

bssoap_labels=dict(external_system='yabs', sub_system='bssoap', method='UpdateData2')
bssoap_requests=RequestsCount(**bssoap_labels)
bs_base_sent_objects=BaseExternalMetric(sensor='objects.sent', external_system='yabs')
direct_banners_log_requests=bssoap_requests.mutate(sub_system='direct-banners-log', method='-')
