from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.cluster import clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service import services


class BaseJobsMetric(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(project=projects.direct.id,
                                 cluster=clusters.jobs_prod.name,
                                 service=services.java_monitoring.name,
                                 host='CLUSTER',
                                 env='production')
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        if other_labels['env'] != 'production':
            other_labels['project'] = projects.direct_test.id
            other_labels['cluster'] = clusters.jobs_test.name
        super().__init__(**other_labels)


threads_running=BaseJobsMetric(sensor='hourglass_running')
threads_count=BaseJobsMetric(sensor='hourglass_threads')
